rule win_unidentified_103_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_103."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_103"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89c3 ffd6 897c2408 c744240400000000 890424 ff942488000000 }
            // n = 6, score = 100
            //   89c3                 | lea                 esi, [esp + 0x94]
            //   ffd6                 | mov                 dword ptr [esp], eax
            //   897c2408             | mov                 ebx, eax
            //   c744240400000000     | mov                 dword ptr [esp + 0x198], 0
            //   890424               | test                eax, eax
            //   ff942488000000       | je                  0x2e7

        $sequence_1 = { 897c2434 8bbc2450010000 894c2430 8b8c244c010000 }
            // n = 4, score = 100
            //   897c2434             | mov                 dword ptr [esp + 0x30], edi
            //   8bbc2450010000       | mov                 edi, dword ptr [esp + 0x154]
            //   894c2430             | mov                 dword ptr [esp + 0x2c], edi
            //   8b8c244c010000       | mov                 edi, dword ptr [esp + 0x150]

        $sequence_2 = { 8944246c 8d842419010000 c784241901000061647661 c784241d01000070693332 c78424210100002e646c6c 890424 }
            // n = 6, score = 100
            //   8944246c             | mov                 dword ptr [esp + 0x60], eax
            //   8d842419010000       | mov                 eax, dword ptr [esp + 0x120]
            //   c784241901000061647661     | mov    dword ptr [esp + 0x68], eax
            //   c784241d01000070693332     | lea    eax, [esp + 0x126]
            //   c78424210100002e646c6c     | mov    dword ptr [esp + 4], eax
            //   890424               | mov                 dword ptr [esp + 0x126], 0x65766552

        $sequence_3 = { 8b3c24 85ff 743a c6012d c6441e0200 89d3 0fb60c06 }
            // n = 7, score = 100
            //   8b3c24               | mov                 dword ptr [esp + 0x1c], esi
            //   85ff                 | mov                 ebx, edx
            //   743a                 | mov                 ecx, edx
            //   c6012d               | and                 ebx, 0xfffffffc
            //   c6441e0200           | shr                 ecx, 2
            //   89d3                 | mov                 edi, dword ptr [ecx]
            //   0fb60c06             | mov                 eax, edi

        $sequence_4 = { 8b8424c4000000 ffd0 83ec04 c684249001000000 8dac240c060000 c78424c403000000000000 }
            // n = 6, score = 100
            //   8b8424c4000000       | cmp                 byte ptr [esp + 0x3c8], 0
            //   ffd0                 | lea                 edx, [esp + 0x3c8]
            //   83ec04               | mov                 eax, dword ptr [esp + 0xc4]
            //   c684249001000000     | call                eax
            //   8dac240c060000       | xor                 eax, eax
            //   c78424c403000000000000     | mov    ecx, 0x70

        $sequence_5 = { 8b842440010000 89442418 8b842438010000 89442414 8b8424d0000000 8b00 89442404 }
            // n = 7, score = 100
            //   8b842440010000       | mov                 eax, dword ptr [esp + 0x738]
            //   89442418             | mov                 dword ptr [esp + 0x5c], eax
            //   8b842438010000       | mov                 eax, dword ptr [esp + 0x73c]
            //   89442414             | mov                 dword ptr [esp + 0x78], eax
            //   8b8424d0000000       | mov                 byte ptr [esp + 0xfe], 0
            //   8b00                 | mov                 dword ptr [esp + 0xf2], 0x64616f4c
            //   89442404             | mov                 eax, dword ptr [esp + 0x13c]

        $sequence_6 = { 8d54244a 83c001 803c0200 75f7 8b8c2498000000 c744240c34020000 }
            // n = 6, score = 100
            //   8d54244a             | cmp                 ebx, dword ptr [esp + 0x2c]
            //   83c001               | jbe                 0x28
            //   803c0200             | lea                 edx, [esp + 0x1c]
            //   75f7                 | mov                 dword ptr [esp + 8], eax
            //   8b8c2498000000       | mov                 dword ptr [esp + 0xc], edx
            //   c744240c34020000     | call                ecx

        $sequence_7 = { c78424a60000007072696e c68424ac00000000 e8???????? b865000000 31db c784241c03000028010000 c7842433010000576d6950 }
            // n = 7, score = 100
            //   c78424a60000007072696e     | mov    dword ptr [esp + 0x3b8], 0x2e646d63
            //   c68424ac00000000     | mov                 dword ptr [esp + 0x3bc], 0x657865
            //   e8????????           |                     
            //   b865000000           | lea                 eax, [esi + eax - 5]
            //   31db                 | cmp                 byte ptr [eax], 0xa
            //   c784241c03000028010000     | je    0xc01
            //   c7842433010000576d6950     | mov    ebx, dword ptr [esp + 0xb4]

        $sequence_8 = { 89442404 c78424d201000052656164 c78424d601000046696c65 c68424da01000000 e8???????? 891c24 8984241c010000 }
            // n = 7, score = 100
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   c78424d201000052656164     | mov    dword ptr [esp + 0xca], 0x797261
            //   c78424d601000046696c65     | lea    eax, [esp + 0x14e]
            //   c68424da01000000     | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   891c24               | mov                 dword ptr [esp + 4], eax
            //   8984241c010000       | mov                 word ptr [esp + 0x15a], di

        $sequence_9 = { 897c2420 8bbc2444010000 897c241c 8bbc2440010000 897c2418 8bbc2488010000 }
            // n = 6, score = 100
            //   897c2420             | mov                 dword ptr [esp + 0x14], esi
            //   8bbc2444010000       | mov                 dword ptr [esp + 0x10], edi
            //   897c241c             | mov                 dword ptr [esp + 0x1c], edi
            //   8bbc2440010000       | mov                 edi, dword ptr [esp + 0x184]
            //   897c2418             | mov                 dword ptr [esp + 0x20], esi
            //   8bbc2488010000       | mov                 esi, dword ptr [esp + 0x188]

    condition:
        7 of them and filesize < 188416
}