rule win_unidentified_105_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_105."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_105"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 6800100000 8bf0 57 56 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   6800100000           | push                0x1000
            //   8bf0                 | mov                 esi, eax
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_1 = { 6a00 8d8dd0feffff 51 8d95fcfeffff }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   8d8dd0feffff         | lea                 ecx, [ebp - 0x130]
            //   51                   | push                ecx
            //   8d95fcfeffff         | lea                 edx, [ebp - 0x104]

        $sequence_2 = { e8???????? 8bd8 83c404 53 8bce }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   83c404               | add                 esp, 4
            //   53                   | push                ebx
            //   8bce                 | mov                 ecx, esi

        $sequence_3 = { e8???????? 6800002000 8bf8 6a00 57 897df4 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   6800002000           | push                0x200000
            //   8bf8                 | mov                 edi, eax
            //   6a00                 | push                0
            //   57                   | push                edi
            //   897df4               | mov                 dword ptr [ebp - 0xc], edi

        $sequence_4 = { 8a08 40 84c9 75f9 2bc2 6a02 8d4c30fe }
            // n = 7, score = 200
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bc2                 | sub                 eax, edx
            //   6a02                 | push                2
            //   8d4c30fe             | lea                 ecx, [eax + esi - 2]

        $sequence_5 = { 85c0 750d 68???????? e8???????? 83c404 8b8df0efffff }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b8df0efffff         | mov                 ecx, dword ptr [ebp - 0x1010]

        $sequence_6 = { 8b742414 83c404 b9???????? 8bc6 8d642400 }
            // n = 5, score = 200
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]
            //   83c404               | add                 esp, 4
            //   b9????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   8d642400             | lea                 esp, [esp]

        $sequence_7 = { 8b3d???????? 8d45e4 50 33f6 }
            // n = 4, score = 200
            //   8b3d????????         |                     
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   33f6                 | xor                 esi, esi

        $sequence_8 = { eb13 83f801 750e a1???????? }
            // n = 4, score = 200
            //   eb13                 | jmp                 0x15
            //   83f801               | cmp                 eax, 1
            //   750e                 | jne                 0x10
            //   a1????????           |                     

        $sequence_9 = { 8b85f4efffff 83c40c 6a00 8d8decefffff 51 6800100000 }
            // n = 6, score = 200
            //   8b85f4efffff         | mov                 eax, dword ptr [ebp - 0x100c]
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0
            //   8d8decefffff         | lea                 ecx, [ebp - 0x1014]
            //   51                   | push                ecx
            //   6800100000           | push                0x1000

    condition:
        7 of them and filesize < 253952
}