rule win_unidentified_108_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_108."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_108"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8d05a21d0100 488bf9 488d15a01d0100 b904000000 e8???????? 8bd3 }
            // n = 6, score = 100
            //   4c8d05a21d0100       | lea                 ecx, [0x1a528]
            //   488bf9               | jmp                 0xb5
            //   488d15a01d0100       | cmp                 ecx, 1
            //   b904000000           | xor                 edx, edx
            //   e8????????           |                     
            //   8bd3                 | inc                 ecx

        $sequence_1 = { 48c1fe06 4c8d2d0a5b0100 83e03f 4c8d24c0 498b44f500 }
            // n = 5, score = 100
            //   48c1fe06             | dec                 eax
            //   4c8d2d0a5b0100       | lea                 ecx, [ebp + 0x88]
            //   83e03f               | mov                 byte ptr [ebp + 0x98], al
            //   4c8d24c0             | inc                 ebp
            //   498b44f500           | mov                 eax, ebp

        $sequence_2 = { 488d15e7f30000 83e03f 4d8bfd 49c1ff06 41b90a000000 488d3cc0 }
            // n = 6, score = 100
            //   488d15e7f30000       | sub                 esi, edi
            //   83e03f               | dec                 eax
            //   4d8bfd               | lea                 ebx, [0xffff635a]
            //   49c1ff06             | mov                 al, byte ptr [esi + edi]
            //   41b90a000000         | dec                 ebp
            //   488d3cc0             | test                ecx, ecx

        $sequence_3 = { 742e 488d5510 0f1f840000000000 803201 }
            // n = 4, score = 100
            //   742e                 | dec                 eax
            //   488d5510             | lea                 ebx, [0x19f8e]
            //   0f1f840000000000     | inc                 ecx
            //   803201               | mov                 eax, 0x104

        $sequence_4 = { 8b0d???????? 458bc5 f20f1005???????? 488bf8 }
            // n = 4, score = 100
            //   8b0d????????         |                     
            //   458bc5               | lea                 edx, [ecx + 0x19920]
            //   f20f1005????????     |                     
            //   488bf8               | dec                 eax

        $sequence_5 = { 488d5201 41ffc0 488d4520 498bcc }
            // n = 4, score = 100
            //   488d5201             | mov                 dword ptr [esp + 0x6f8], esi
            //   41ffc0               | dec                 eax
            //   488d4520             | mov                 ecx, edi
            //   498bcc               | dec                 eax

        $sequence_6 = { 4c8d15e0f40000 83e03f 498bd5 48c1fa06 }
            // n = 4, score = 100
            //   4c8d15e0f40000       | jge                 0xb03
            //   83e03f               | dec                 eax
            //   498bd5               | lea                 ecx, [0x165a9]
            //   48c1fa06             | dec                 eax

        $sequence_7 = { 736e 488bc3 488bf3 48c1fe06 4c8d2d4ef70000 83e03f }
            // n = 6, score = 100
            //   736e                 | dec                 ebp
            //   488bc3               | mov                 edi, edx
            //   488bf3               | inc                 ecx
            //   48c1fe06             | mov                 eax, ebp
            //   4c8d2d4ef70000       | not                 eax
            //   83e03f               | inc                 ecx

        $sequence_8 = { 486bc000 488d0d5ed50100 8b542430 48891401 488d0dd7250100 e8???????? }
            // n = 6, score = 100
            //   486bc000             | lea                 ecx, [ebp + 0xa0]
            //   488d0d5ed50100       | dec                 eax
            //   8b542430             | dec                 ecx
            //   48891401             | nop                 
            //   488d0dd7250100       | inc                 esp
            //   e8????????           |                     

        $sequence_9 = { 48894dff 83e03f 458be9 488d0dd066ffff 4c8945e7 }
            // n = 5, score = 100
            //   48894dff             | dec                 eax
            //   83e03f               | lea                 ecx, [0xffff66d0]
            //   458be9               | dec                 esp
            //   488d0dd066ffff       | mov                 dword ptr [ebp - 0x19], eax
            //   4c8945e7             | and                 eax, 0x3f

    condition:
        7 of them and filesize < 307200
}