rule win_unidentified_109_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_109."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_109"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc8 d1e8 410bc1 83e101 41ffc8 894204 448bc9 }
            // n = 7, score = 100
            //   8bc8                 | inc                 ecx
            //   d1e8                 | add                 ecx, ecx
            //   410bc1               | and                 eax, ecx
            //   83e101               | inc                 ecx
            //   41ffc8               | xor                 eax, eax
            //   894204               | inc                 ecx
            //   448bc9               | add                 eax, 0x242070db

        $sequence_1 = { 488bd9 418bf9 498bf0 448bd2 b1e4 85d2 }
            // n = 6, score = 100
            //   488bd9               | dec                 esp
            //   418bf9               | mov                 dword ptr [ebp - 0x20], esi
            //   498bf0               | dec                 esp
            //   448bd2               | mov                 dword ptr [ebp - 0x30], esi
            //   b1e4                 | inc                 esp
            //   85d2                 | mov                 dword ptr [ebp - 0x28], esi

        $sequence_2 = { 418bc8 0bcb 41c1c01e 418bd1 4123cb c1c205 0bc8 }
            // n = 7, score = 100
            //   418bc8               | dec                 eax
            //   0bcb                 | lea                 edx, [0x11bf3]
            //   41c1c01e             | xor                 ecx, ecx
            //   418bd1               | test                eax, eax
            //   4123cb               | je                  0xe42
            //   c1c205               | dec                 eax
            //   0bc8                 | mov                 ecx, dword ptr [esp + 0x50]

        $sequence_3 = { 410fb7c0 6641ffc0 c644080433 664585c9 0f84e0000000 410fb7c0 6641ffc0 }
            // n = 7, score = 100
            //   410fb7c0             | dec                 eax
            //   6641ffc0             | mov                 edi, dword ptr [esp + 0x30]
            //   c644080433           | dec                 eax
            //   664585c9             | mov                 ebx, dword ptr [esp + 0x38]
            //   0f84e0000000         | dec                 eax
            //   410fb7c0             | add                 esp, 0x20
            //   6641ffc0             | pop                 esi

        $sequence_4 = { ffc8 410f48c6 4585c0 7e38 4898 660f1f440000 493bc6 }
            // n = 7, score = 100
            //   ffc8                 | dec                 ecx
            //   410f48c6             | jne                 0x522
            //   4585c0               | inc                 ecx
            //   7e38                 | mov                 byte ptr [edx], bh
            //   4898                 | dec                 eax
            //   660f1f440000         | mov                 edi, dword ptr [esp + 0x18]
            //   493bc6               | inc                 edx

        $sequence_5 = { 0fb6d2 83e27f 8d041a 3bc6 0f8742010000 85d2 7416 }
            // n = 7, score = 100
            //   0fb6d2               | lock dec            dword ptr [ecx]
            //   83e27f               | jne                 0x3ff
            //   8d041a               | dec                 eax
            //   3bc6                 | lea                 eax, [0x1ebe7]
            //   0f8742010000         | dec                 eax
            //   85d2                 | mov                 dword ptr [esp + 0x30], ecx
            //   7416                 | jmp                 0x3fb

        $sequence_6 = { 7453 85db 744b 48897c2430 0f1f4000 498d8ef8000000 488bd6 }
            // n = 7, score = 100
            //   7453                 | add                 edi, ebp
            //   85db                 | test                byte ptr [ebx + 0x38c], 4
            //   744b                 | jne                 0x48
            //   48897c2430           | dec                 eax
            //   0f1f4000             | arpl                di, si
            //   498d8ef8000000       | dec                 ecx
            //   488bd6               | add                 esi, esp

        $sequence_7 = { 488945d0 488945d8 488945e0 488d4de8 498bd9 418bf6 4c8975f8 }
            // n = 7, score = 100
            //   488945d0             | arpl                word ptr [ebx], ax
            //   488945d8             | cmp                 eax, 0x20
            //   488945e0             | jle                 0x2f8
            //   488d4de8             | mov                 eax, 0xffffff74
            //   498bd9               | jmp                 0x315
            //   418bf6               | jne                 0x326
            //   4c8975f8             | dec                 eax

        $sequence_8 = { 790a c705????????00000000 488d0dfaf80400 ff15???????? 85db 488b5c2420 7441 }
            // n = 7, score = 100
            //   790a                 | mov                 dword ptr [esp + 0x30], esi
            //   c705????????00000000     |     
            //   488d0dfaf80400       | dec                 esp
            //   ff15????????         |                     
            //   85db                 | mov                 dword ptr [esp + 0x38], esi
            //   488b5c2420           | inc                 ebp
            //   7441                 | xor                 esi, esi

        $sequence_9 = { 8bc1 448bc1 2bc6 03c2 413bc1 77de 03ca }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, esi
            //   448bc1               | shr                 eax, 8
            //   2bc6                 | mov                 byte ptr [edi + 7], al
            //   03c2                 | inc                 eax
            //   413bc1               | mov                 byte ptr [esp + 0x53], bh
            //   77de                 | test                eax, eax
            //   03ca                 | jne                 0x330

    condition:
        7 of them and filesize < 723968
}