rule win_unidentified_112_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_112."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_112"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 4883ec38 488daa80000000 48817d70ff7f0000 762e c6858f00000000 c6858e00000000 }
            // n = 7, score = 100
            //   53                   | cmp                 byte ptr [eax + 0xa2a], 0
            //   4883ec38             | je                  0xb25
            //   488daa80000000       | push                ebx
            //   48817d70ff7f0000     | dec                 eax
            //   762e                 | sub                 esp, 0x38
            //   c6858f00000000       | dec                 eax
            //   c6858e00000000       | lea                 ebp, [edx + 0x80]

        $sequence_1 = { e8???????? 84c0 0f8496000000 b12c e8???????? 84c0 0f8487000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | test                eax, eax
            //   0f8496000000         | je                  0x708
            //   b12c                 | test                al, al
            //   e8????????           |                     
            //   84c0                 | je                  0x356
            //   0f8487000000         | dec                 ecx

        $sequence_2 = { 498d4850 498b5040 4d8b4048 ff5010 4883bde001000000 7525 488b85d8020000 }
            // n = 7, score = 100
            //   498d4850             | dec                 eax
            //   498b5040             | cmovae              edx, eax
            //   4d8b4048             | movzx               ecx, word ptr [ebp + 0xe8]
            //   ff5010               | mov                 al, 7
            //   4883bde001000000     | dec                 ecx
            //   7525                 | lea                 eax, [ecx - 1]
            //   488b85d8020000       | dec                 eax

        $sequence_3 = { e8???????? 498b4e50 ba50000000 41b808000000 e8???????? 488b45f0 49894650 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   498b4e50             | inc                 ebp
            //   ba50000000           | xor                 edi, edi
            //   41b808000000         | dec                 eax
            //   e8????????           |                     
            //   488b45f0             | test                ebx, ebx
            //   49894650             | dec                 ecx

        $sequence_4 = { c1ea13 448d0c12 478d0c89 4429c8 0c30 8841ff 48ffc9 }
            // n = 7, score = 100
            //   c1ea13               | inc                 eax
            //   448d0c12             | cmp                 bh, 0xf0
            //   478d0c89             | jb                  0x62a
            //   4429c8               | inc                 ecx
            //   0c30                 | movzx               esi, byte ptr [eax + 3]
            //   8841ff               | dec                 ecx
            //   48ffc9               | add                 eax, 4

        $sequence_5 = { e8???????? 84c0 0f841bf5ffff 488b05???????? 488b08 488b4138 4885c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | dec                 eax
            //   0f841bf5ffff         | lea                 edx, [ebp + 0x4e8]
            //   488b05????????       |                     
            //   488b08               | inc                 ecx
            //   488b4138             | mov                 eax, 0xa0
            //   4885c0               | cmp                 edi, 2

        $sequence_6 = { 56 57 53 4883ec28 488daa80000000 488b8d48100000 488bb550100000 }
            // n = 7, score = 100
            //   56                   | dec                 eax
            //   57                   | lea                 ebp, [esp + 0x80]
            //   53                   | dec                 eax
            //   4883ec28             | mov                 dword ptr [ebp + 0x160], 0xfffffffe
            //   488daa80000000       | dec                 eax
            //   488b8d48100000       | mov                 esi, edx
            //   488bb550100000       | push                esi

        $sequence_7 = { c685de01000000 488d8d50010000 e8???????? eb71 488b8550010000 488b8d58010000 488b9560010000 }
            // n = 7, score = 100
            //   c685de01000000       | mov                 byte ptr [esi], 3
            //   488d8d50010000       | dec                 eax
            //   e8????????           |                     
            //   eb71                 | lea                 ecx, [ebp - 0x58]
            //   488b8550010000       | dec                 eax
            //   488b8d58010000       | lea                 ecx, [ebp + 8]
            //   488b9560010000       | mov                 byte ptr [ebp + 0x3cf], 1

        $sequence_8 = { ba22000000 e8???????? e9???????? c685e305000001 488d0d4bd01500 4c8d053cd31500 ba22000000 }
            // n = 7, score = 100
            //   ba22000000           | dec                 eax
            //   e8????????           |                     
            //   e9????????           |                     
            //   c685e305000001       | lea                 ecx, [0x16a74a]
            //   488d0d4bd01500       | dec                 esp
            //   4c8d053cd31500       | lea                 eax, [0x16a7e3]
            //   ba22000000           | mov                 edx, 0x3b

        $sequence_9 = { eb56 31f6 4989dd bf03000000 eb4a 0fb7ca 25ff030000 }
            // n = 7, score = 100
            //   eb56                 | lea                 eax, [0x11b53a]
            //   31f6                 | dec                 eax
            //   4989dd               | mov                 dword ptr [ebp + 0x48], eax
            //   bf03000000           | dec                 eax
            //   eb4a                 | mov                 dword ptr [ebp + 0x50], 1
            //   0fb7ca               | jmp                 0x14b
            //   25ff030000           | dec                 eax

    condition:
        7 of them and filesize < 7317504
}