rule win_unidentified_113_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_113."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_113"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c408 be08000000 e9???????? 83f904 0f82a2000000 807c19fe3e }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   be08000000           | mov                 esi, 8
            //   e9????????           |                     
            //   83f904               | cmp                 ecx, 4
            //   0f82a2000000         | jb                  0xa8
            //   807c19fe3e           | cmp                 byte ptr [ecx + ebx - 2], 0x3e

        $sequence_1 = { ff742434 ff15???????? ff74243c ff15???????? 57 ff15???????? 8b8c2468030000 }
            // n = 7, score = 100
            //   ff742434             | push                dword ptr [esp + 0x34]
            //   ff15????????         |                     
            //   ff74243c             | push                dword ptr [esp + 0x3c]
            //   ff15????????         |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b8c2468030000       | mov                 ecx, dword ptr [esp + 0x368]

        $sequence_2 = { e8???????? 83c40c 8b4c2410 83c502 83d100 894c2410 85c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   83c502               | add                 ebp, 2
            //   83d100               | adc                 ecx, 0
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   85c0                 | test                eax, eax

        $sequence_3 = { ff74242c 55 57 e8???????? 55 8bf8 e8???????? }
            // n = 7, score = 100
            //   ff74242c             | push                dword ptr [esp + 0x2c]
            //   55                   | push                ebp
            //   57                   | push                edi
            //   e8????????           |                     
            //   55                   | push                ebp
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     

        $sequence_4 = { ffd6 ff742414 ffd6 8b8c247c040000 5e 33cc e8???????? }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   ffd6                 | call                esi
            //   8b8c247c040000       | mov                 ecx, dword ptr [esp + 0x47c]
            //   5e                   | pop                 esi
            //   33cc                 | xor                 ecx, esp
            //   e8????????           |                     

        $sequence_5 = { ff7630 e8???????? 6a38 6a00 56 e8???????? 8b4710 }
            // n = 7, score = 100
            //   ff7630               | push                dword ptr [esi + 0x30]
            //   e8????????           |                     
            //   6a38                 | push                0x38
            //   6a00                 | push                0
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]

        $sequence_6 = { ff15???????? 8bd8 899da0feffff 85db 0f84fc030000 0f1f440000 ff15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   899da0feffff         | mov                 dword ptr [ebp - 0x160], ebx
            //   85db                 | test                ebx, ebx
            //   0f84fc030000         | je                  0x402
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   ff15????????         |                     

        $sequence_7 = { e8???????? 89442424 83c408 8bc7 837c241c00 0f44d8 53 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   83c408               | add                 esp, 8
            //   8bc7                 | mov                 eax, edi
            //   837c241c00           | cmp                 dword ptr [esp + 0x1c], 0
            //   0f44d8               | cmove               ebx, eax
            //   53                   | push                ebx

        $sequence_8 = { c785acf3ffff00000000 0fb608 8bd1 c785b0f3ffff00000000 c785b4f3ffff00000080 83ea01 741d }
            // n = 7, score = 100
            //   c785acf3ffff00000000     | mov    dword ptr [ebp - 0xc54], 0
            //   0fb608               | movzx               ecx, byte ptr [eax]
            //   8bd1                 | mov                 edx, ecx
            //   c785b0f3ffff00000000     | mov    dword ptr [ebp - 0xc50], 0
            //   c785b4f3ffff00000080     | mov    dword ptr [ebp - 0xc4c], 0x80000000
            //   83ea01               | sub                 edx, 1
            //   741d                 | je                  0x1f

        $sequence_9 = { ff7020 8d44242c 50 8b442434 50 8b4020 ffd0 }
            // n = 7, score = 100
            //   ff7020               | push                dword ptr [eax + 0x20]
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   50                   | push                eax
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   50                   | push                eax
            //   8b4020               | mov                 eax, dword ptr [eax + 0x20]
            //   ffd0                 | call                eax

    condition:
        7 of them and filesize < 4707328
}