rule win_unidentified_115_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_115."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_115"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488945f0 488b05???????? 488945f8 ff15???????? 488d0d72f80000 ff15???????? }
            // n = 6, score = 100
            //   488945f0             | inc                 esp
            //   488b05????????       |                     
            //   488945f8             | mov                 ecx, dword ptr [ecx]
            //   ff15????????         |                     
            //   488d0d72f80000       | dec                 esp
            //   ff15????????         |                     

        $sequence_1 = { 488d0d8f150100 eb62 488b1d???????? 4c8d4c2428 ba01000000 4889c1 41b840000000 }
            // n = 7, score = 100
            //   488d0d8f150100       | sub                 esp, 0x38
            //   eb62                 | inc                 ebp
            //   488b1d????????       |                     
            //   4c8d4c2428           | xor                 ebp, ebp
            //   ba01000000           | dec                 eax
            //   4889c1               | arpl                cx, si
            //   41b840000000         | dec                 eax

        $sequence_2 = { 488b13 4889f1 4883c308 e8???????? ebea 4881c420010000 5b }
            // n = 7, score = 100
            //   488b13               | lea                 ecx, [0x1b9ad]
            //   4889f1               | dec                 esp
            //   4883c308             | lea                 eax, [0x1b9b4]
            //   e8????????           |                     
            //   ebea                 | dec                 esp
            //   4881c420010000       | mov                 ecx, esp
            //   5b                   | dec                 eax

        $sequence_3 = { ffd3 488d1590f60100 4889c1 e8???????? b901000000 e8???????? 90 }
            // n = 7, score = 100
            //   ffd3                 | inc                 ebp
            //   488d1590f60100       | mov                 eax, ecx
            //   4889c1               | inc                 esp
            //   e8????????           |                     
            //   b901000000           | add                 ebp, ebx
            //   e8????????           |                     
            //   90                   | inc                 ecx

        $sequence_4 = { 48893d???????? 498dbe50010000 48891d???????? 488d1d80dc0300 4c891d???????? 4c8d1d72e10300 }
            // n = 6, score = 100
            //   48893d????????       |                     
            //   498dbe50010000       | inc                 cx
            //   48891d????????       |                     
            //   488d1d80dc0300       | cmp                 ebp, 0xf
            //   4c891d????????       |                     
            //   4c8d1d72e10300       | jbe                 0x188

        $sequence_5 = { 483346f0 4889842490000000 e9???????? 488b3a 4883c208 4889f8 4989fc }
            // n = 7, score = 100
            //   483346f0             | div                 eax
            //   4889842490000000     | dec                 eax
            //   e9????????           |                     
            //   488b3a               | add                 edx, edx
            //   4883c208             | inc                 esp
            //   4889f8               | mov                 dl, byte ptr [ecx + edx + 1]
            //   4989fc               | dec                 eax

        $sequence_6 = { 488b15???????? 4c89e1 e8???????? 4989c4 e9???????? 488b43f0 488d53f0 }
            // n = 7, score = 100
            //   488b15????????       |                     
            //   4c89e1               | lea                 ecx, [0x1a2c2]
            //   e8????????           |                     
            //   4989c4               | dec                 esp
            //   e9????????           |                     
            //   488b43f0             | lea                 ecx, [0x28160]
            //   488d53f0             | dec                 esp

        $sequence_7 = { 488b03 4989df 4889fa 4885c0 7403 488b10 498b4f08 }
            // n = 7, score = 100
            //   488b03               | dec                 esp
            //   4989df               | mov                 ecx, esp
            //   4889fa               | dec                 eax
            //   4885c0               | add                 esp, 0x20
            //   7403                 | pop                 ebx
            //   488b10               | dec                 esp
            //   498b4f08             | mov                 eax, dword ptr [esp + 0x28]

        $sequence_8 = { 4c8d2d33db0200 e8???????? 4c89e9 4889c2 e8???????? 488b0d???????? ba18000000 }
            // n = 7, score = 100
            //   4c8d2d33db0200       | add                 ebx, 0x10
            //   e8????????           |                     
            //   4c89e9               | dec                 eax
            //   4889c2               | lea                 ebp, [esp + 0x28]
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   ba18000000           | inc                 ecx

        $sequence_9 = { 89dd c1c507 4431d5 448b9424d8000000 428db416708b4bc2 4189da 01ee }
            // n = 7, score = 100
            //   89dd                 | dec                 eax
            //   c1c507               | lea                 edx, [0xe058]
            //   4431d5               | jg                  0x22d
            //   448b9424d8000000     | dec                 esp
            //   428db416708b4bc2     | mov                 edx, ebp
            //   4189da               | dec                 eax
            //   01ee                 | cmp                 edx, ebx

    condition:
        7 of them and filesize < 648192
}