rule win_unidentified_116_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_116."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_116"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 8d0d628bfaff ff15???????? 48 8d05158bfaff 83fe01 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8d0d628bfaff         | lea                 ecx, [0xfffa8b62]
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   8d05158bfaff         | lea                 eax, [0xfffa8b15]
            //   83fe01               | cmp                 esi, 1
            //   48                   | dec                 eax

        $sequence_1 = { e8???????? 48 89442428 4c 8d05a724fcff 4c }
            // n = 6, score = 100
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   4c                   | dec                 esp
            //   8d05a724fcff         | lea                 eax, [0xfffc24a7]
            //   4c                   | dec                 esp

        $sequence_2 = { ff15???????? 83f8ff 7508 ff15???????? 8bd8 4c 8b8608010000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   7508                 | jne                 0xa
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   4c                   | dec                 esp
            //   8b8608010000         | mov                 eax, dword ptr [esi + 0x108]

        $sequence_3 = { 8bd9 48 8901 f6c201 740a ba38000000 e8???????? }
            // n = 7, score = 100
            //   8bd9                 | mov                 ebx, ecx
            //   48                   | dec                 eax
            //   8901                 | mov                 dword ptr [ecx], eax
            //   f6c201               | test                dl, 1
            //   740a                 | je                  0xc
            //   ba38000000           | mov                 edx, 0x38
            //   e8????????           |                     

        $sequence_4 = { 8b7c2460 49 63e8 48 03ea 44 8b3f }
            // n = 7, score = 100
            //   8b7c2460             | mov                 edi, dword ptr [esp + 0x60]
            //   49                   | dec                 ecx
            //   63e8                 | arpl                ax, bp
            //   48                   | dec                 eax
            //   03ea                 | add                 ebp, edx
            //   44                   | inc                 esp
            //   8b3f                 | mov                 edi, dword ptr [edi]

        $sequence_5 = { 8bc0 c1e010 c1e910 0bc8 41 c1e810 0fb6432f }
            // n = 7, score = 100
            //   8bc0                 | mov                 eax, eax
            //   c1e010               | shl                 eax, 0x10
            //   c1e910               | shr                 ecx, 0x10
            //   0bc8                 | or                  ecx, eax
            //   41                   | inc                 ecx
            //   c1e810               | shr                 eax, 0x10
            //   0fb6432f             | movzx               eax, byte ptr [ebx + 0x2f]

        $sequence_6 = { eb44 48 8b4c2420 e8???????? 48 8bf8 48 }
            // n = 7, score = 100
            //   eb44                 | jmp                 0x46
            //   48                   | dec                 eax
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8bf8                 | mov                 edi, eax
            //   48                   | dec                 eax

        $sequence_7 = { f20f59d3 48 03c2 48 ba00803ed5 deb19d014803 c28944 }
            // n = 7, score = 100
            //   f20f59d3             | mulsd               xmm2, xmm3
            //   48                   | dec                 eax
            //   03c2                 | add                 eax, edx
            //   48                   | dec                 eax
            //   ba00803ed5           | mov                 edx, 0xd53e8000
            //   deb19d014803         | fidiv               word ptr [ecx + 0x348019d]
            //   c28944               | ret                 0x4489

        $sequence_8 = { 41 5e c3 48 896c2430 48 897c2440 }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   48                   | dec                 eax
            //   896c2430             | mov                 dword ptr [esp + 0x30], ebp
            //   48                   | dec                 eax
            //   897c2440             | mov                 dword ptr [esp + 0x40], edi

        $sequence_9 = { 8bf9 0f84be000000 48 895c2430 48 89742438 48 }
            // n = 7, score = 100
            //   8bf9                 | mov                 edi, ecx
            //   0f84be000000         | je                  0xc4
            //   48                   | dec                 eax
            //   895c2430             | mov                 dword ptr [esp + 0x30], ebx
            //   48                   | dec                 eax
            //   89742438             | mov                 dword ptr [esp + 0x38], esi
            //   48                   | dec                 eax

    condition:
        7 of them and filesize < 1040384
}