rule win_urausy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.urausy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.urausy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7508 e8???????? 8945ec ff7514 e8???????? 8945e8 }
            // n = 6, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   e8????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_1 = { ff75a0 ff75ec e8???????? 33c0 b4ff b0ff c1c008 }
            // n = 7, score = 200
            //   ff75a0               | push                dword ptr [ebp - 0x60]
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   b4ff                 | mov                 ah, 0xff
            //   b0ff                 | mov                 al, 0xff
            //   c1c008               | rol                 eax, 8

        $sequence_2 = { e8???????? 5e 6a00 6a00 6a00 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   5e                   | pop                 esi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_3 = { ff7594 ff7598 ff75ec e8???????? 33c0 }
            // n = 5, score = 200
            //   ff7594               | push                dword ptr [ebp - 0x6c]
            //   ff7598               | push                dword ptr [ebp - 0x68]
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 6a28 ff75e4 ff75e8 6802000050 68???????? 68???????? 6800000400 }
            // n = 7, score = 200
            //   6a28                 | push                0x28
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   6802000050           | push                0x50000002
            //   68????????           |                     
            //   68????????           |                     
            //   6800000400           | push                0x40000

        $sequence_5 = { e8???????? 53 e8???????? 8d85f8fdffff }
            // n = 4, score = 200
            //   e8????????           |                     
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]

        $sequence_6 = { ff75e8 e8???????? c9 c21000 55 8bec 81c4ecefffff }
            // n = 7, score = 200
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   e8????????           |                     
            //   c9                   | leave               
            //   c21000               | ret                 0x10
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c4ecefffff         | add                 esp, 0xffffefec

        $sequence_7 = { 8b4508 50 8b00 ff5018 8d45e0 }
            // n = 5, score = 200
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ff5018               | call                dword ptr [eax + 0x18]
            //   8d45e0               | lea                 eax, [ebp - 0x20]

        $sequence_8 = { 83c4e8 833d????????01 7504 c9 }
            // n = 4, score = 200
            //   83c4e8               | add                 esp, -0x18
            //   833d????????01       |                     
            //   7504                 | jne                 6
            //   c9                   | leave               

        $sequence_9 = { e8???????? c9 c20400 55 8bec 83c4e8 8d45f0 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83c4e8               | add                 esp, -0x18
            //   8d45f0               | lea                 eax, [ebp - 0x10]

    condition:
        7 of them and filesize < 98304
}