rule win_valkyrie_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.valkyrie_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.valkyrie_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89442430 85c0 0f85ab130000 4a8b4c3500 44396914 7d18 e8???????? }
            // n = 7, score = 100
            //   89442430             | dec                 eax
            //   85c0                 | sub                 eax, ecx
            //   0f85ab130000         | dec                 eax
            //   4a8b4c3500           | add                 eax, -8
            //   44396914             | dec                 eax
            //   7d18                 | cmp                 eax, 0x1f
            //   e8????????           |                     

        $sequence_1 = { 85c9 741c 498b07 44386067 750f 498b8788000000 488d0c49 }
            // n = 7, score = 100
            //   85c9                 | sub                 edx, ecx
            //   741c                 | dec                 eax
            //   498b07               | cmp                 edx, 0x1000
            //   44386067             | jb                  0x67e
            //   750f                 | dec                 esp
            //   498b8788000000       | mov                 eax, dword ptr [ecx - 8]
            //   488d0c49             | dec                 eax

        $sequence_2 = { e8???????? 448b4ddc eb2a 8d4101 418907 488d0c49 488b8388000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   448b4ddc             | dec                 eax
            //   eb2a                 | test                eax, eax
            //   8d4101               | dec                 eax
            //   418907               | lea                 eax, [eax + 1]
            //   488d0c49             | jne                 0x1c8c
            //   488b8388000000       | dec                 eax

        $sequence_3 = { 8bc2 c645b82d c1e81f 03d0 c645bb20 c645be3a 8d0492 }
            // n = 7, score = 100
            //   8bc2                 | mov                 eax, ebx
            //   c645b82d             | dec                 esp
            //   c1e81f               | lea                 ebx, [esp + 0x60]
            //   03d0                 | dec                 ecx
            //   c645bb20             | mov                 ebx, dword ptr [ebx + 0x28]
            //   c645be3a             | dec                 ecx
            //   8d0492               | mov                 ebp, dword ptr [ebx + 0x30]

        $sequence_4 = { 8bde eb4e 803c3e75 751b 8d4305 413bc6 7359 }
            // n = 7, score = 100
            //   8bde                 | inc                 esp
            //   eb4e                 | mov                 esp, dword ptr [esp + 0xc8]
            //   803c3e75             | inc                 ebp
            //   751b                 | test                esp, esp
            //   8d4305               | je                  0xacc
            //   413bc6               | dec                 eax
            //   7359                 | mov                 ecx, ebx

        $sequence_5 = { e8???????? 8d4701 e9???????? 8bcd 488d15829f0b00 4803ce 41b804000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4701               | dec                 eax
            //   e9????????           |                     
            //   8bcd                 | inc                 edi
            //   488d15829f0b00       | dec                 ecx
            //   4803ce               | sub                 esi, 1
            //   41b804000000         | jne                 0xea

        $sequence_6 = { 8b8590000000 ffc8 4898 488d0c40 488d1ccf 0fbe4301 3cfa }
            // n = 7, score = 100
            //   8b8590000000         | dec                 eax
            //   ffc8                 | mov                 ebx, dword ptr [esp + 0x88]
            //   4898                 | dec                 eax
            //   488d0c40             | add                 esp, 0x70
            //   488d1ccf             | pop                 edi
            //   0fbe4301             | dec                 eax
            //   3cfa                 | mov                 esi, dword ptr [esp + 0x80]

        $sequence_7 = { 7417 4c8b542448 41f6427002 750b 410fbae61c 0f820c010000 488b85f0000000 }
            // n = 7, score = 100
            //   7417                 | mov                 ecx, ebx
            //   4c8b542448           | inc                 ebp
            //   41f6427002           | mov                 eax, esp
            //   750b                 | mov                 edx, 0x8a
            //   410fbae61c           | dec                 eax
            //   0f820c010000         | arpl                word ptr [edi + 0x90], cx
            //   488b85f0000000       | cmp                 dword ptr [edi + 0x94], ecx

        $sequence_8 = { 488bf0 4885c0 0f84cb000000 837d0800 7411 488b4f20 498bd6 }
            // n = 7, score = 100
            //   488bf0               | dec                 eax
            //   4885c0               | mov                 dword ptr [esp + 0x20], eax
            //   0f84cb000000         | dec                 eax
            //   837d0800             | lea                 edx, [0xa908f]
            //   7411                 | xor                 esi, esi
            //   488b4f20             | dec                 ecx
            //   498bd6               | mov                 eax, dword ptr [esi + 0x18]

        $sequence_9 = { eb25 48c744242002000000 4c8d0d17781100 4533c0 ba02000000 488d8c2498000000 e8???????? }
            // n = 7, score = 100
            //   eb25                 | inc                 eax
            //   48c744242002000000     | cmp    byte ptr [ebx + 0x10], ch
            //   4c8d0d17781100       | dec                 ecx
            //   4533c0               | mov                 ebx, dword ptr [edi + 8]
            //   ba02000000           | inc                 sp
            //   488d8c2498000000     | cmp                 esi, ebp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 2895872
}