rule win_valley_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.valley_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.valley_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 005c7e46 00847e46008a46 0323 d188470383ee }
            // n = 4, score = 100
            //   005c7e46             | add                 byte ptr [esi + edi*2 + 0x46], bl
            //   00847e46008a46       | add                 byte ptr [esi + edi*2 + 0x468a0046], al
            //   0323                 | add                 esp, dword ptr [ebx]
            //   d188470383ee         | ror                 dword ptr [eax - 0x117cfcb9], 1

        $sequence_1 = { c785dcfbffff9b9bcc64 c785e0fbffffee6364c8 c785e4fbffff97f1dbf3 c785e8fbffff9bab9b9b c785ecfbffff25539b9b c785f0fbffff9bcdcc64 }
            // n = 6, score = 100
            //   c785dcfbffff9b9bcc64     | mov    dword ptr [ebp - 0x424], 0x64cc9b9b
            //   c785e0fbffffee6364c8     | mov    dword ptr [ebp - 0x420], 0xc86463ee
            //   c785e4fbffff97f1dbf3     | mov    dword ptr [ebp - 0x41c], 0xf3dbf197
            //   c785e8fbffff9bab9b9b     | mov    dword ptr [ebp - 0x418], 0x9b9bab9b
            //   c785ecfbffff25539b9b     | mov    dword ptr [ebp - 0x414], 0x9b9b5325
            //   c785f0fbffff9bcdcc64     | mov    dword ptr [ebp - 0x410], 0x64cccd9b

        $sequence_2 = { 897e48 897e40 897e44 89464c 8d442408 }
            // n = 5, score = 100
            //   897e48               | mov                 dword ptr [esi + 0x48], edi
            //   897e40               | mov                 dword ptr [esi + 0x40], edi
            //   897e44               | mov                 dword ptr [esi + 0x44], edi
            //   89464c               | mov                 dword ptr [esi + 0x4c], eax
            //   8d442408             | lea                 eax, [esp + 8]

        $sequence_3 = { 0101 0505050505 0505050505 0505050505 0505050505 0505050505 }
            // n = 6, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   0505050505           | add                 eax, 0x5050505
            //   0505050505           | add                 eax, 0x5050505
            //   0505050505           | add                 eax, 0x5050505
            //   0505050505           | add                 eax, 0x5050505
            //   0505050505           | add                 eax, 0x5050505

        $sequence_4 = { 51 8d93440a0000 52 e8???????? 83c40c }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   8d93440a0000         | lea                 edx, [ebx + 0xa44]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { 0101 0101 0201 0102 }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   0101                 | add                 dword ptr [ecx], eax
            //   0201                 | add                 al, byte ptr [ecx]
            //   0102                 | add                 dword ptr [edx], eax

        $sequence_6 = { 0101 0101 0101 0101 0101 0505050505 }
            // n = 6, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   0101                 | add                 dword ptr [ecx], eax
            //   0101                 | add                 dword ptr [ecx], eax
            //   0101                 | add                 dword ptr [ecx], eax
            //   0101                 | add                 dword ptr [ecx], eax
            //   0505050505           | add                 eax, 0x5050505

        $sequence_7 = { 0001 0101 0102 0101 }
            // n = 4, score = 100
            //   0001                 | add                 byte ptr [ecx], al
            //   0101                 | add                 dword ptr [ecx], eax
            //   0102                 | add                 dword ptr [edx], eax
            //   0101                 | add                 dword ptr [ecx], eax

        $sequence_8 = { c78530feffff73cacd64 c78534feffffce97707a c78538fefffffefffee9 c7853cfefffff7f4f8f0 c78540feffff9b9b9b9b c78544feffff9b9b9b9b c78548feffff9b9b9b9b }
            // n = 7, score = 100
            //   c78530feffff73cacd64     | mov    dword ptr [ebp - 0x1d0], 0x64cdca73
            //   c78534feffffce97707a     | mov    dword ptr [ebp - 0x1cc], 0x7a7097ce
            //   c78538fefffffefffee9     | mov    dword ptr [ebp - 0x1c8], 0xe9fefffe
            //   c7853cfefffff7f4f8f0     | mov    dword ptr [ebp - 0x1c4], 0xf0f8f4f7
            //   c78540feffff9b9b9b9b     | mov    dword ptr [ebp - 0x1c0], 0x9b9b9b9b
            //   c78544feffff9b9b9b9b     | mov    dword ptr [ebp - 0x1bc], 0x9b9b9b9b
            //   c78548feffff9b9b9b9b     | mov    dword ptr [ebp - 0x1b8], 0x9b9b9b9b

        $sequence_9 = { 0101 33c0 5e 5b }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_10 = { 8b15???????? 6800300000 52 50 ff15???????? 8b0d???????? 51 }
            // n = 7, score = 100
            //   8b15????????         |                     
            //   6800300000           | push                0x3000
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b0d????????         |                     
            //   51                   | push                ecx

        $sequence_11 = { c785c0f6ffff8173599d c785c4f6ffff9b9bcbf3 c785c8f6ffffe384bbe4 c785ccf6ffff12dfbfab }
            // n = 4, score = 100
            //   c785c0f6ffff8173599d     | mov    dword ptr [ebp - 0x940], 0x9d597381
            //   c785c4f6ffff9b9bcbf3     | mov    dword ptr [ebp - 0x93c], 0xf3cb9b9b
            //   c785c8f6ffffe384bbe4     | mov    dword ptr [ebp - 0x938], 0xe4bb84e3
            //   c785ccf6ffff12dfbfab     | mov    dword ptr [ebp - 0x934], 0xabbfdf12

        $sequence_12 = { e8???????? 8b0d???????? 83c418 890d???????? 891d???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   83c418               | add                 esp, 0x18
            //   890d????????         |                     
            //   891d????????         |                     

        $sequence_13 = { 00bcaf4500c5af 45 00f8 af }
            // n = 4, score = 100
            //   00bcaf4500c5af       | add                 byte ptr [edi + ebp*4 - 0x503affbb], bh
            //   45                   | inc                 ebp
            //   00f8                 | add                 al, bh
            //   af                   | scasd               eax, dword ptr es:[edi]

        $sequence_14 = { c785e8f7ffffdf10dfbf c785ecf7ffffe7f1dbcd c785f0f7ffff64ebb7c8 c785f4f7ffff64cfbfa3 c785f8f7ffff10d7bfe7 c785fcf7ffff121fbf13 c78500f8ffff9b9b9b64 }
            // n = 7, score = 100
            //   c785e8f7ffffdf10dfbf     | mov    dword ptr [ebp - 0x818], 0xbfdf10df
            //   c785ecf7ffffe7f1dbcd     | mov    dword ptr [ebp - 0x814], 0xcddbf1e7
            //   c785f0f7ffff64ebb7c8     | mov    dword ptr [ebp - 0x810], 0xc8b7eb64
            //   c785f4f7ffff64cfbfa3     | mov    dword ptr [ebp - 0x80c], 0xa3bfcf64
            //   c785f8f7ffff10d7bfe7     | mov    dword ptr [ebp - 0x808], 0xe7bfd710
            //   c785fcf7ffff121fbf13     | mov    dword ptr [ebp - 0x804], 0x13bf1f12
            //   c78500f8ffff9b9b9b64     | mov    dword ptr [ebp - 0x800], 0x649b9b9b

        $sequence_15 = { 0101 33c0 8be5 5d }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   33c0                 | xor                 eax, eax
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 2256896
}