rule win_vapor_rage_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vapor_rage."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vapor_rage"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f2e94e030000 55 8bec 5d e9???????? 55 }
            // n = 6, score = 200
            //   f2e94e030000         | bnd jmp             0x354
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   e9????????           |                     
            //   55                   | push                ebp

        $sequence_1 = { 8d450c 50 8b4d08 51 6a02 ff15???????? 85c0 }
            // n = 7, score = 200
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 6a00 8d55ec 52 8b45d4 }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   52                   | push                edx
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]

        $sequence_3 = { 8d55ec 52 8b45d4 50 6a05 8b4de4 51 }
            // n = 7, score = 200
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   52                   | push                edx
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   50                   | push                eax
            //   6a05                 | push                5
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   51                   | push                ecx

        $sequence_4 = { c3 3b0d???????? f27502 f2c3 f2e94e030000 }
            // n = 5, score = 200
            //   c3                   | ret                 
            //   3b0d????????         |                     
            //   f27502               | bnd jne             5
            //   f2c3                 | bnd ret             
            //   f2e94e030000         | bnd jmp             0x354

        $sequence_5 = { 6a03 6a00 6a00 0fb755b0 52 }
            // n = 5, score = 200
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   0fb755b0             | movzx               edx, word ptr [ebp - 0x50]
            //   52                   | push                edx

        $sequence_6 = { 50 8b4d08 51 6a02 ff15???????? 85c0 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 3b0d???????? f27502 f2c3 f2e94e030000 55 }
            // n = 5, score = 200
            //   3b0d????????         |                     
            //   f27502               | bnd jne             5
            //   f2c3                 | bnd ret             
            //   f2e94e030000         | bnd jmp             0x354
            //   55                   | push                ebp

        $sequence_8 = { ff15???????? 8b4df8 81c900010000 894df8 8b55f8 81ca80000000 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   81c900010000         | or                  ecx, 0x100
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   81ca80000000         | or                  edx, 0x80

        $sequence_9 = { 83c404 8945c4 8b45c4 8945d0 }
            // n = 4, score = 200
            //   83c404               | add                 esp, 4
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax

    condition:
        7 of them and filesize < 296960
}