rule win_varenyky_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.varenyky."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.varenyky"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 1bc0 83d8ff 85c0 0f8467010000 8d8c2490000000 51 6804010000 }
            // n = 7, score = 100
            //   1bc0                 | sbb                 eax, eax
            //   83d8ff               | sbb                 eax, -1
            //   85c0                 | test                eax, eax
            //   0f8467010000         | je                  0x16d
            //   8d8c2490000000       | lea                 ecx, [esp + 0x90]
            //   51                   | push                ecx
            //   6804010000           | push                0x104

        $sequence_1 = { 85c0 0f8ef7010000 8b15???????? a0???????? 6a00 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f8ef7010000         | jle                 0x1fd
            //   8b15????????         |                     
            //   a0????????           |                     
            //   6a00                 | push                0

        $sequence_2 = { bf697a0000 3bc3 7411 90 69ff81000000 }
            // n = 5, score = 100
            //   bf697a0000           | mov                 edi, 0x7a69
            //   3bc3                 | cmp                 eax, ebx
            //   7411                 | je                  0x13
            //   90                   | nop                 
            //   69ff81000000         | imul                edi, edi, 0x81

        $sequence_3 = { 8d8c2454010000 68???????? 51 e8???????? 8d84245c010000 83c40c 8d5001 }
            // n = 7, score = 100
            //   8d8c2454010000       | lea                 ecx, [esp + 0x154]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8d84245c010000       | lea                 eax, [esp + 0x15c]
            //   83c40c               | add                 esp, 0xc
            //   8d5001               | lea                 edx, [eax + 1]

        $sequence_4 = { 83c40c 8d4c2418 51 8d94244c030000 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   51                   | push                ecx
            //   8d94244c030000       | lea                 edx, [esp + 0x34c]

        $sequence_5 = { 57 e8???????? 83c404 3c33 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3c33                 | cmp                 al, 0x33

        $sequence_6 = { 8d84244d030000 53 50 c744242404010000 889c2454030000 e8???????? }
            // n = 6, score = 100
            //   8d84244d030000       | lea                 eax, [esp + 0x34d]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   c744242404010000     | mov                 dword ptr [esp + 0x24], 0x104
            //   889c2454030000       | mov                 byte ptr [esp + 0x354], bl
            //   e8????????           |                     

        $sequence_7 = { 0f8c0b0a0000 8ac2 2c20 3c58 7711 0fbec2 0fbe8030c24000 }
            // n = 7, score = 100
            //   0f8c0b0a0000         | jl                  0xa11
            //   8ac2                 | mov                 al, dl
            //   2c20                 | sub                 al, 0x20
            //   3c58                 | cmp                 al, 0x58
            //   7711                 | ja                  0x13
            //   0fbec2               | movsx               eax, dl
            //   0fbe8030c24000       | movsx               eax, byte ptr [eax + 0x40c230]

        $sequence_8 = { 3bc3 7411 90 69ff81000000 41 }
            // n = 5, score = 100
            //   3bc3                 | cmp                 eax, ebx
            //   7411                 | je                  0x13
            //   90                   | nop                 
            //   69ff81000000         | imul                edi, edi, 0x81
            //   41                   | inc                 ecx

        $sequence_9 = { 8b84241c010000 83c40c 50 33d2 80bc242602000001 b905000000 0f95c2 }
            // n = 7, score = 100
            //   8b84241c010000       | mov                 eax, dword ptr [esp + 0x11c]
            //   83c40c               | add                 esp, 0xc
            //   50                   | push                eax
            //   33d2                 | xor                 edx, edx
            //   80bc242602000001     | cmp                 byte ptr [esp + 0x226], 1
            //   b905000000           | mov                 ecx, 5
            //   0f95c2               | setne               dl

    condition:
        7 of them and filesize < 24846336
}