rule win_vendetta_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vendetta."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vendetta"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? c745e0e8924100 e9???????? c745e0d4924100 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   c745e0e8924100       | mov                 dword ptr [ebp - 0x20], 0x4192e8
            //   e9????????           |                     
            //   c745e0d4924100       | mov                 dword ptr [ebp - 0x20], 0x4192d4

        $sequence_1 = { 8bf1 83caff bf00040000 0fb60e }
            // n = 4, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   83caff               | or                  edx, 0xffffffff
            //   bf00040000           | mov                 edi, 0x400
            //   0fb60e               | movzx               ecx, byte ptr [esi]

        $sequence_2 = { 40 c745ec7c994000 894df8 8945fc 64a100000000 8945e8 }
            // n = 6, score = 100
            //   40                   | inc                 eax
            //   c745ec7c994000       | mov                 dword ptr [ebp - 0x14], 0x40997c
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_3 = { 83ef01 75d4 f7d2 5f 8bc2 5e }
            // n = 6, score = 100
            //   83ef01               | sub                 edi, 1
            //   75d4                 | jne                 0xffffffd6
            //   f7d2                 | not                 edx
            //   5f                   | pop                 edi
            //   8bc2                 | mov                 eax, edx
            //   5e                   | pop                 esi

        $sequence_4 = { 53 8d85f0f7ffff 50 56 ff15???????? }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   8d85f0f7ffff         | lea                 eax, [ebp - 0x810]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_5 = { 84c0 0f843b010000 8d770c 6a2c }
            // n = 4, score = 100
            //   84c0                 | test                al, al
            //   0f843b010000         | je                  0x141
            //   8d770c               | lea                 esi, [edi + 0xc]
            //   6a2c                 | push                0x2c

        $sequence_6 = { 8b85e0feffff 03b40518ffffff 03b0acb04100 03b5f8feffff }
            // n = 4, score = 100
            //   8b85e0feffff         | mov                 eax, dword ptr [ebp - 0x120]
            //   03b40518ffffff       | add                 esi, dword ptr [ebp + eax - 0xe8]
            //   03b0acb04100         | add                 esi, dword ptr [eax + 0x41b0ac]
            //   03b5f8feffff         | add                 esi, dword ptr [ebp - 0x108]

        $sequence_7 = { 238df4feffff 8b85e0feffff 03b40508ffffff 03b09cb04100 8bc3 03b5dcfeffff 01b5f8feffff }
            // n = 7, score = 100
            //   238df4feffff         | and                 ecx, dword ptr [ebp - 0x10c]
            //   8b85e0feffff         | mov                 eax, dword ptr [ebp - 0x120]
            //   03b40508ffffff       | add                 esi, dword ptr [ebp + eax - 0xf8]
            //   03b09cb04100         | add                 esi, dword ptr [eax + 0x41b09c]
            //   8bc3                 | mov                 eax, ebx
            //   03b5dcfeffff         | add                 esi, dword ptr [ebp - 0x124]
            //   01b5f8feffff         | add                 dword ptr [ebp - 0x108], esi

        $sequence_8 = { 3385ecfeffff 23c2 3385f8feffff 03f0 8b85e0feffff 03b40514ffffff 03b0a8b04100 }
            // n = 7, score = 100
            //   3385ecfeffff         | xor                 eax, dword ptr [ebp - 0x114]
            //   23c2                 | and                 eax, edx
            //   3385f8feffff         | xor                 eax, dword ptr [ebp - 0x108]
            //   03f0                 | add                 esi, eax
            //   8b85e0feffff         | mov                 eax, dword ptr [ebp - 0x120]
            //   03b40514ffffff       | add                 esi, dword ptr [ebp + eax - 0xec]
            //   03b0a8b04100         | add                 esi, dword ptr [eax + 0x41b0a8]

        $sequence_9 = { 7f0e 7c08 81fa00000080 7704 }
            // n = 4, score = 100
            //   7f0e                 | jg                  0x10
            //   7c08                 | jl                  0xa
            //   81fa00000080         | cmp                 edx, 0x80000000
            //   7704                 | ja                  6

    condition:
        7 of them and filesize < 296960
}