rule win_vermilion_strike_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vermilion_strike."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vermilion_strike"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c414 51 52 b330 8d7c2438 }
            // n = 5, score = 200
            //   83c414               | add                 esp, 0x14
            //   51                   | push                ecx
            //   52                   | push                edx
            //   b330                 | mov                 bl, 0x30
            //   8d7c2438             | lea                 edi, [esp + 0x38]

        $sequence_1 = { 8d4e20 51 c744241400000000 e8???????? c7463c00000000 8bc6 8b4c2408 }
            // n = 7, score = 200
            //   8d4e20               | lea                 ecx, [esi + 0x20]
            //   51                   | push                ecx
            //   c744241400000000     | mov                 dword ptr [esp + 0x14], 0
            //   e8????????           |                     
            //   c7463c00000000       | mov                 dword ptr [esi + 0x3c], 0
            //   8bc6                 | mov                 eax, esi
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]

        $sequence_2 = { c644241400 8d7001 8d9b00000000 8a10 40 84d2 }
            // n = 6, score = 200
            //   c644241400           | mov                 byte ptr [esp + 0x14], 0
            //   8d7001               | lea                 esi, [eax + 1]
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84d2                 | test                dl, dl

        $sequence_3 = { 83c404 56 8bd8 6a00 53 895c2418 e8???????? }
            // n = 7, score = 200
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   8bd8                 | mov                 ebx, eax
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   895c2418             | mov                 dword ptr [esp + 0x18], ebx
            //   e8????????           |                     

        $sequence_4 = { 3dea000000 7518 8b74241c 85f6 7410 8d442464 }
            // n = 6, score = 200
            //   3dea000000           | cmp                 eax, 0xea
            //   7518                 | jne                 0x1a
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]
            //   85f6                 | test                esi, esi
            //   7410                 | je                  0x12
            //   8d442464             | lea                 eax, [esp + 0x64]

        $sequence_5 = { ffd7 8bf0 83feff 7532 ffd5 }
            // n = 5, score = 200
            //   ffd7                 | call                edi
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   7532                 | jne                 0x34
            //   ffd5                 | call                ebp

        $sequence_6 = { 895c2448 885c2438 39bc2484000000 720d 8b542470 }
            // n = 5, score = 200
            //   895c2448             | mov                 dword ptr [esp + 0x48], ebx
            //   885c2438             | mov                 byte ptr [esp + 0x38], bl
            //   39bc2484000000       | cmp                 dword ptr [esp + 0x84], edi
            //   720d                 | jb                  0xf
            //   8b542470             | mov                 edx, dword ptr [esp + 0x70]

        $sequence_7 = { 396e18 7205 8b4e04 eb03 8d4e04 50 51 }
            // n = 7, score = 200
            //   396e18               | cmp                 dword ptr [esi + 0x18], ebp
            //   7205                 | jb                  7
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   eb03                 | jmp                 5
            //   8d4e04               | lea                 ecx, [esi + 4]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_8 = { e8???????? 57 50 8d7c245c c684245801000003 e8???????? 83c40c }
            // n = 7, score = 200
            //   e8????????           |                     
            //   57                   | push                edi
            //   50                   | push                eax
            //   8d7c245c             | lea                 edi, [esp + 0x5c]
            //   c684245801000003     | mov                 byte ptr [esp + 0x158], 3
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_9 = { eb02 8bc7 3bc3 7711 83f908 }
            // n = 5, score = 200
            //   eb02                 | jmp                 4
            //   8bc7                 | mov                 eax, edi
            //   3bc3                 | cmp                 eax, ebx
            //   7711                 | ja                  0x13
            //   83f908               | cmp                 ecx, 8

    condition:
        7 of them and filesize < 540672
}