rule win_vidar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vidar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vidar"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 25ff7f0000 c3 e8???????? 8b486c }
            // n = 4, score = 2600
            //   25ff7f0000           | and                 eax, 0x7fff
            //   c3                   | ret                 
            //   e8????????           |                     
            //   8b486c               | mov                 ecx, dword ptr [eax + 0x6c]

        $sequence_1 = { 7202 8b00 8d8d68fdffff 51 50 }
            // n = 5, score = 2500
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8d8d68fdffff         | lea                 ecx, [ebp - 0x298]
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_2 = { 8b8648af0100 c1e803 038644af0100 5e 5d c3 }
            // n = 6, score = 2400
            //   8b8648af0100         | mov                 eax, dword ptr [esi + 0x1af48]
            //   c1e803               | shr                 eax, 3
            //   038644af0100         | add                 eax, dword ptr [esi + 0x1af44]
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_3 = { 56 8b742408 8b865caf0100 57 }
            // n = 4, score = 2400
            //   56                   | push                eax
            //   8b742408             | jb                  4
            //   8b865caf0100         | mov                 eax, dword ptr [eax]
            //   57                   | lea                 ecx, [ebp - 0x298]

        $sequence_4 = { 8b7508 33ff 89b55cfdffff 89bd60fdffff 8d450c }
            // n = 5, score = 2400
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33ff                 | xor                 edi, edi
            //   89b55cfdffff         | mov                 dword ptr [ebp - 0x2a4], esi
            //   89bd60fdffff         | mov                 dword ptr [ebp - 0x2a0], edi
            //   8d450c               | lea                 eax, [ebp + 0xc]

        $sequence_5 = { e8???????? d9450c 51 8d8d58ffffff d91c24 }
            // n = 5, score = 2400
            //   e8????????           |                     
            //   d9450c               | fld                 dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   8d8d58ffffff         | lea                 ecx, [ebp - 0xa8]
            //   d91c24               | fstp                dword ptr [esp]

        $sequence_6 = { 8b7508 33db 895dd0 c746140f000000 895e10 8975cc }
            // n = 6, score = 2400
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33db                 | xor                 ebx, ebx
            //   895dd0               | mov                 dword ptr [ebp - 0x30], ebx
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx
            //   8975cc               | mov                 dword ptr [ebp - 0x34], esi

        $sequence_7 = { d9e0 d99d00ffffff d98500ffffff d91c24 }
            // n = 4, score = 2400
            //   d9e0                 | fchs                
            //   d99d00ffffff         | fstp                dword ptr [ebp - 0x100]
            //   d98500ffffff         | fld                 dword ptr [ebp - 0x100]
            //   d91c24               | fstp                dword ptr [esp]

        $sequence_8 = { 740a b800000500 e9???????? 57 }
            // n = 4, score = 2400
            //   740a                 | mov                 dword ptr [esi + 0x10], ebx
            //   b800000500           | mov                 dword ptr [ebp - 0x34], esi
            //   e9????????           |                     
            //   57                   | mov                 byte ptr [esi], bl

        $sequence_9 = { 5f c6043300 8bc6 5e 5b c20400 }
            // n = 6, score = 2400
            //   5f                   | mov                 eax, dword ptr [eax]
            //   c6043300             | lea                 ecx, [ebp - 0x298]
            //   8bc6                 | push                ecx
            //   5e                   | push                eax
            //   5b                   | mov                 dword ptr [ebp - 4], ebx
            //   c20400               | cmp                 dword ptr [eax + 0x14], 8

        $sequence_10 = { 895dfc e8???????? 83781408 c645fc01 }
            // n = 4, score = 2400
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   e8????????           |                     
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1

        $sequence_11 = { b800020000 e9???????? 8b4dc8 33c0 }
            // n = 4, score = 2300
            //   b800020000           | mov                 esi, dword ptr [ebp + 8]
            //   e9????????           |                     
            //   8b4dc8               | xor                 ebx, ebx
            //   33c0                 | mov                 dword ptr [ebp - 0x30], ebx

        $sequence_12 = { 5e c20400 ff742408 e8???????? 59 83f8ff }
            // n = 6, score = 2300
            //   5e                   | ret                 
            //   c20400               | mov                 dword ptr [ebp - 0x30], ebx
            //   ff742408             | mov                 dword ptr [esi + 0x14], 0xf
            //   e8????????           |                     
            //   59                   | mov                 dword ptr [esi + 0x10], ebx
            //   83f8ff               | mov                 dword ptr [ebp - 0x34], esi

        $sequence_13 = { c745f41e000000 c745f80f000000 8955fc 8bcb }
            // n = 4, score = 2300
            //   c745f41e000000       | mov                 eax, dword ptr [eax]
            //   c745f80f000000       | lea                 ecx, [ebp - 0x298]
            //   8955fc               | push                ecx
            //   8bcb                 | push                eax

        $sequence_14 = { e8???????? 56 53 8d4d80 e8???????? }
            // n = 5, score = 2300
            //   e8????????           |                     
            //   56                   | mov                 dword ptr [esi + 0x14], 0xf
            //   53                   | mov                 dword ptr [esi + 0x10], ebx
            //   8d4d80               | mov                 dword ptr [ebp - 0x34], esi
            //   e8????????           |                     

        $sequence_15 = { ff15???????? 89460c 3bc3 7507 }
            // n = 4, score = 2300
            //   ff15????????         |                     
            //   89460c               | mov                 byte ptr [ebp - 4], 1
            //   3bc3                 | jb                  0xc
            //   7507                 | mov                 dword ptr [ebp - 4], ebx

        $sequence_16 = { f3a5 8d88e00e0000 894de4 8bcb }
            // n = 4, score = 2300
            //   f3a5                 | mov                 dword ptr [ebp - 0x30], ebx
            //   8d88e00e0000         | mov                 dword ptr [esi + 0x14], 0xf
            //   894de4               | mov                 dword ptr [esi + 0x10], ebx
            //   8bcb                 | mov                 dword ptr [ebp - 0x34], esi

        $sequence_17 = { e8???????? 59 83f8ff 7503 32c0 c3 }
            // n = 6, score = 2300
            //   e8????????           |                     
            //   59                   | mov                 dword ptr [ebp - 0x34], esi
            //   83f8ff               | mov                 byte ptr [esi], bl
            //   7503                 | xor                 edi, edi
            //   32c0                 | mov                 dword ptr [ebp - 0x2a4], esi
            //   c3                   | mov                 dword ptr [ebp - 0x2a0], edi

        $sequence_18 = { 83781410 7202 8b00 50 8b45a0 }
            // n = 5, score = 2300
            //   83781410             | shr                 eax, 0x10
            //   7202                 | and                 eax, 0x7fff
            //   8b00                 | ret                 
            //   50                   | mov                 dword ptr [ecx + 0x14], eax
            //   8b45a0               | shr                 eax, 0x10

        $sequence_19 = { c1e004 8bf0 0fbe4301 50 }
            // n = 4, score = 2300
            //   c1e004               | mov                 dword ptr [ebp - 8], 0xf
            //   8bf0                 | mov                 dword ptr [ebp - 4], edx
            //   0fbe4301             | mov                 ecx, ebx
            //   50                   | mov                 dword ptr [ebp - 0xc], 0x1e

        $sequence_20 = { c9 c3 8b542408 85d2 7503 33c0 c3 }
            // n = 7, score = 2300
            //   c9                   | and                 eax, 0x7fff
            //   c3                   | ret                 
            //   8b542408             | mov                 ecx, dword ptr [eax + 0x6c]
            //   85d2                 | shr                 eax, 0x10
            //   7503                 | and                 eax, 0x7fff
            //   33c0                 | ret                 
            //   c3                   | mov                 ecx, dword ptr [eax + 0x6c]

        $sequence_21 = { 53 68???????? 6802000080 ff15???????? 85c0 751b }
            // n = 6, score = 2300
            //   53                   | mov                 dword ptr [ebp - 8], 0xf
            //   68????????           |                     
            //   6802000080           | mov                 dword ptr [ebp - 4], edx
            //   ff15????????         |                     
            //   85c0                 | mov                 ecx, ebx
            //   751b                 | lea                 edi, [eax + 0xf98]

        $sequence_22 = { 50 ff15???????? 8b4da0 8901 85c0 }
            // n = 5, score = 2300
            //   50                   | shr                 eax, 0x10
            //   ff15????????         |                     
            //   8b4da0               | and                 eax, 0x7fff
            //   8901                 | ret                 
            //   85c0                 | mov                 ecx, dword ptr [eax + 0x6c]

        $sequence_23 = { 50 6a09 53 68???????? }
            // n = 4, score = 2200
            //   50                   | mov                 ecx, ebx
            //   6a09                 | mov                 dword ptr [ebp - 0xc], 0x11e
            //   53                   | mov                 dword ptr [ebp - 8], 0xf
            //   68????????           |                     

        $sequence_24 = { 0fb605???????? 50 0fb605???????? 50 0fb605???????? 50 6a01 }
            // n = 7, score = 2200
            //   0fb605????????       |                     
            //   50                   | mov                 eax, ecx
            //   0fb605????????       |                     
            //   50                   | push                eax
            //   0fb605????????       |                     
            //   50                   | pop                 ecx
            //   6a01                 | push                eax

        $sequence_25 = { 68???????? e8???????? 59 83f820 }
            // n = 4, score = 2200
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | lea                 esi, [ebp - 0x1c]
            //   83f820               | mov                 dword ptr [ebp - 0xc], 0x1e

        $sequence_26 = { 395df0 7411 ff75f0 53 }
            // n = 4, score = 2100
            //   395df0               | push                esi
            //   7411                 | mov                 eax, dword ptr [ebp + 8]
            //   ff75f0               | mov                 dword ptr [esi], eax
            //   53                   | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_27 = { 53 50 899e6caf0600 e8???????? }
            // n = 4, score = 2100
            //   53                   | mov                 dword ptr [ebp - 4], ebx
            //   50                   | cmp                 dword ptr [eax + 0x14], 8
            //   899e6caf0600         | mov                 byte ptr [ebp - 4], 1
            //   e8????????           |                     

        $sequence_28 = { 53 68???????? 8d8da8000000 e8???????? }
            // n = 4, score = 2100
            //   53                   | mov                 ecx, dword ptr [eax + 0x6c]
            //   68????????           |                     
            //   8d8da8000000         | shr                 eax, 0x10
            //   e8????????           |                     

        $sequence_29 = { 895df0 8d45f0 50 6a09 }
            // n = 4, score = 2100
            //   895df0               | push                dword ptr [esp + 8]
            //   8d45f0               | pop                 ecx
            //   50                   | cmp                 eax, -1
            //   6a09                 | jne                 8

        $sequence_30 = { 399e70af0600 7514 c78678af060001000000 c78670af060000000100 68fcff0100 8d8670af0400 53 }
            // n = 7, score = 2100
            //   399e70af0600         | jb                  0xc
            //   7514                 | mov                 dword ptr [ebp - 0x30], ebx
            //   c78678af060001000000     | mov    dword ptr [esi + 0x14], 0xf
            //   c78670af060000000100     | mov    dword ptr [esi + 0x10], ebx
            //   68fcff0100           | mov                 dword ptr [ebp - 0x34], esi
            //   8d8670af0400         | mov                 dword ptr [ebp - 4], ebx
            //   53                   | cmp                 dword ptr [eax + 0x14], 8

        $sequence_31 = { 7411 395df0 740c ff75f0 ff15???????? 895df0 }
            // n = 6, score = 2100
            //   7411                 | ret                 4
            //   395df0               | push                dword ptr [esp + 8]
            //   740c                 | pop                 ecx
            //   ff75f0               | cmp                 eax, -1
            //   ff15????????         |                     
            //   895df0               | ret                 4

        $sequence_32 = { 741d ff75f0 ff15???????? 895df0 395df0 740c ff75f0 }
            // n = 7, score = 2100
            //   741d                 | jne                 5
            //   ff75f0               | xor                 al, al
            //   ff15????????         |                     
            //   895df0               | ret                 
            //   395df0               | pop                 ecx
            //   740c                 | cmp                 eax, -1
            //   ff75f0               | jne                 5

        $sequence_33 = { c3 55 8bec 83ec0c 8365fc00 8365f400 8365f800 }
            // n = 7, score = 1900
            //   c3                   | test                eax, eax
            //   55                   | mov                 eax, ecx
            //   8bec                 | push                eax
            //   83ec0c               | pop                 ecx
            //   8365fc00             | pop                 ecx
            //   8365f400             | test                eax, eax
            //   8365f800             | je                  0xffffffe3

        $sequence_34 = { 8d852cffffff 50 8d459c 50 }
            // n = 4, score = 1800
            //   8d852cffffff         | shl                 eax, 4
            //   50                   | mov                 esi, eax
            //   8d459c               | movsx               eax, byte ptr [ebx + 1]
            //   50                   | push                eax

        $sequence_35 = { 0faf450c 50 e8???????? 59 }
            // n = 4, score = 1800
            //   0faf450c             | mov                 dword ptr [ecx], eax
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | mov                 ecx, dword ptr [ebp - 0x60]

        $sequence_36 = { 8b4508 8906 8b450c 894608 8b4510 }
            // n = 5, score = 1800
            //   8b4508               | push                ecx
            //   8906                 | push                eax
            //   8b450c               | mov                 eax, dword ptr [eax]
            //   894608               | lea                 ecx, [ebp - 0x298]
            //   8b4510               | push                ecx

        $sequence_37 = { e8???????? c9 c3 55 8bec 83ec18 8b450c }
            // n = 7, score = 1800
            //   e8????????           |                     
            //   c9                   | mov                 esi, eax
            //   c3                   | movsx               eax, byte ptr [ebx + 1]
            //   55                   | push                eax
            //   8bec                 | mov                 eax, ecx
            //   83ec18               | push                eax
            //   8b450c               | pop                 ecx

        $sequence_38 = { 8910 8b4120 8910 8b4130 8910 c3 56 }
            // n = 7, score = 1800
            //   8910                 | push                eax
            //   8b4120               | cmp                 dword ptr [eax + 0x14], 0x10
            //   8910                 | jb                  8
            //   8b4130               | mov                 eax, dword ptr [eax]
            //   8910                 | push                eax
            //   c3                   | mov                 eax, dword ptr [ebp - 0x60]
            //   56                   | jb                  4

        $sequence_39 = { 50 ff15???????? 6a1a e8???????? }
            // n = 4, score = 800
            //   50                   | mov                 esi, eax
            //   ff15????????         |                     
            //   6a1a                 | movsx               eax, byte ptr [ebx + 1]
            //   e8????????           |                     

        $sequence_40 = { 6860ea0000 6a00 ff15???????? 50 }
            // n = 4, score = 800
            //   6860ea0000           | mov                 eax, ecx
            //   6a00                 | push                eax
            //   ff15????????         |                     
            //   50                   | shl                 eax, 4

        $sequence_41 = { 5f c21000 8bff 55 8bec 6a0a }
            // n = 6, score = 700
            //   5f                   | lea                 eax, [ebp - 0x10]
            //   c21000               | push                eax
            //   8bff                 | push                9
            //   55                   | push                ebx
            //   8bec                 | lea                 eax, [ebp - 0x10]
            //   6a0a                 | push                eax

        $sequence_42 = { 5b 5d c3 b84d5a0000 }
            // n = 4, score = 300
            //   5b                   | cmove               eax, ecx
            //   5d                   | jmp                 0xffffffcf
            //   c3                   | cmp                 dword ptr [esp + 0xa4], 0
            //   b84d5a0000           | mov                 eax, 0xaac822ea

        $sequence_43 = { 83f8ff 740c a810 7508 }
            // n = 4, score = 300
            //   83f8ff               | mov                 ecx, 0xb6baa0a5
            //   740c                 | cmove               eax, ecx
            //   a810                 | jmp                 0xffffffe6
            //   7508                 | cmp                 eax, 0x57e31cb0

        $sequence_44 = { eb0b 8b45f4 0500040000 8945f4 }
            // n = 4, score = 200
            //   eb0b                 | jb                  8
            //   8b45f4               | xor                 ebx, ebx
            //   0500040000           | mov                 dword ptr [ebp - 0x30], ebx
            //   8945f4               | mov                 dword ptr [esi + 0x14], 0xf

        $sequence_45 = { dd1c24 6a0b 6a10 e8???????? 83c41c 8be5 }
            // n = 6, score = 200
            //   dd1c24               | and                 eax, 0x7fff
            //   6a0b                 | ret                 
            //   6a10                 | mov                 ecx, dword ptr [eax + 0x6c]
            //   e8????????           |                     
            //   83c41c               | add                 eax, 0x269ec3
            //   8be5                 | mov                 dword ptr [ecx + 0x14], eax

        $sequence_46 = { 4c8bc7 33d2 488bc8 ff15???????? e8???????? }
            // n = 5, score = 200
            //   4c8bc7               | dec                 esp
            //   33d2                 | mov                 eax, edi
            //   488bc8               | xor                 edx, edx
            //   ff15????????         |                     
            //   e8????????           |                     

        $sequence_47 = { dd45f0 dd1c24 83ec08 dd4508 dd1c24 6a0b 6a10 }
            // n = 7, score = 200
            //   dd45f0               | shr                 eax, 0x10
            //   dd1c24               | and                 eax, 0x7fff
            //   83ec08               | ret                 
            //   dd4508               | mov                 ecx, dword ptr [eax + 0x6c]
            //   dd1c24               | add                 eax, 0x269ec3
            //   6a0b                 | mov                 dword ptr [ecx + 0x14], eax
            //   6a10                 | shr                 eax, 0x10

        $sequence_48 = { 492bc1 483d40420f00 0f87f0000000 458bc7 }
            // n = 4, score = 100
            //   492bc1               | dec                 esp
            //   483d40420f00         | mov                 eax, edi
            //   0f87f0000000         | xor                 edx, edx
            //   458bc7               | dec                 eax

        $sequence_49 = { 2bd3 03ca 4103cb 0f84de010000 4863442440 33d2 440fb6743001 }
            // n = 7, score = 100
            //   2bd3                 | dec                 eax
            //   03ca                 | lea                 ecx, [ebp + 0x310]
            //   4103cb               | xorps               xmm0, xmm0
            //   0f84de010000         | dec                 eax
            //   4863442440           | cvtpi2ps            xmm0, mm2
            //   33d2                 | xor                 edx, edx
            //   440fb6743001         | mulsd               xmm1, xmm0

        $sequence_50 = { 83bc24a400000000 b8ea22c8aa b9a5a0bab6 0f44c1 }
            // n = 4, score = 100
            //   83bc24a400000000     | mov                 eax, 0x2f460cc0
            //   b8ea22c8aa           | mov                 ecx, 0x1410b32f
            //   b9a5a0bab6           | cmove               ecx, eax
            //   0f44c1               | mov                 dword ptr [esp + 0x70], ecx

        $sequence_51 = { f30fe6c9 f20f58c0 f20f5cc8 f20f59ce f20f114c2458 0fbe05???????? 0fbe0d???????? }
            // n = 7, score = 100
            //   f30fe6c9             | movsd               qword ptr [esp + 0x50], xmm1
            //   f20f58c0             | sub                 edx, ebx
            //   f20f5cc8             | add                 ecx, edx
            //   f20f59ce             | inc                 ecx
            //   f20f114c2458         | add                 ecx, ebx
            //   0fbe05????????       |                     
            //   0fbe0d????????       |                     

        $sequence_52 = { 83bc249400000000 b9ed1334e4 b8302e84ed 0f4fc8 e9???????? 8b8c248c000000 }
            // n = 6, score = 100
            //   83bc249400000000     | fld                 dword ptr [ebp + 0xc]
            //   b9ed1334e4           | push                ecx
            //   b8302e84ed           | lea                 ecx, [ebp - 0xa8]
            //   0f4fc8               | fstp                dword ptr [esp]
            //   e9????????           |                     
            //   8b8c248c000000       | fld                 dword ptr [ebp + 0xc]

        $sequence_53 = { 8bd7 8bc5 83ee04 7211 8b0a }
            // n = 5, score = 100
            //   8bd7                 | mov                 dword ptr [esi + 0x10], ebx
            //   8bc5                 | mov                 dword ptr [ebp - 0x34], esi
            //   83ee04               | mov                 byte ptr [esi], bl
            //   7211                 | xor                 edi, edi
            //   8b0a                 | mov                 dword ptr [ebp - 0x2a4], esi

        $sequence_54 = { 83bc249c00000000 bf9def53cd b8a3d8a22f 0f4ff8 }
            // n = 4, score = 100
            //   83bc249c00000000     | cmp                 dword ptr [esp + 0x98], 0xf
            //   bf9def53cd           | mov                 ecx, 0xca8143fe
            //   b8a3d8a22f           | mov                 eax, 0x6b16af00
            //   0f4ff8               | cmovl               ecx, eax

        $sequence_55 = { 83bc24a004000000 b9e2dadbde 0f8408ffffff b95fc85b65 }
            // n = 4, score = 100
            //   83bc24a004000000     | cmovg               edi, eax
            //   b9e2dadbde           | mov                 eax, 0xd7701b7c
            //   0f8408ffffff         | cmp                 dword ptr [esp + 0x9c], 0
            //   b95fc85b65           | mov                 edi, 0xcd53ef9d

        $sequence_56 = { 492bc3 493bc2 7708 41ffc0 }
            // n = 4, score = 100
            //   492bc3               | inc                 ecx
            //   493bc2               | cmp                 ecx, 0xb71b00
            //   7708                 | dec                 ecx
            //   41ffc0               | sub                 eax, edx

        $sequence_57 = { 2bc1 f2480f2ac0 f20f59442458 f20f2cc0 894590 4863442440 }
            // n = 6, score = 100
            //   2bc1                 | inc                 esp
            //   f2480f2ac0           | movzx               esi, byte ptr [eax + esi + 1]
            //   f20f59442458         | cvtdq2pd            xmm1, xmm1
            //   f20f2cc0             | addsd               xmm0, xmm0
            //   894590               | subsd               xmm1, xmm0
            //   4863442440           | mulsd               xmm1, xmm6

        $sequence_58 = { 492bc2 483bc1 770c 41ffc1 }
            // n = 4, score = 100
            //   492bc2               | and                 eax, edx
            //   483bc1               | dec                 ecx
            //   770c                 | cmp                 eax, ebx
            //   41ffc1               | ja                  0x44

        $sequence_59 = { 83bc24a007000000 b8c00c462f b92fb31014 0f44c8 }
            // n = 4, score = 100
            //   83bc24a007000000     | je                  0xffffff33
            //   b8c00c462f           | mov                 ecx, 0x655bc85f
            //   b92fb31014           | cmp                 dword ptr [esp + 0x4a0], 0
            //   0f44c8               | mov                 ecx, 0xdedbdae2

        $sequence_60 = { 8bd8 33da 80f101 898c2484000000 }
            // n = 4, score = 100
            //   8bd8                 | ret                 
            //   33da                 | mov                 edx, dword ptr [esp + 8]
            //   80f101               | test                edx, edx
            //   898c2484000000       | jne                 0xb

        $sequence_61 = { 8bd8 23d1 8b149518d54600 c1eb08 }
            // n = 4, score = 100
            //   8bd8                 | push                ecx
            //   23d1                 | lea                 ecx, [ebp - 0xa8]
            //   8b149518d54600       | fstp                dword ptr [esp]
            //   c1eb08               | fld                 dword ptr [ebp + 0xc]

        $sequence_62 = { 0f57c0 f2480f2ac2 33d2 f20f59c8 f20f114c2450 0fbe05???????? }
            // n = 6, score = 100
            //   0f57c0               | dec                 eax
            //   f2480f2ac2           | mov                 edi, dword ptr [esp + 0x40]
            //   33d2                 | mov                 esi, dword ptr [esp + 0x50]
            //   f20f59c8             | dec                 eax
            //   f20f114c2450         | lea                 ecx, [0x2701c]
            //   0fbe05????????       |                     

        $sequence_63 = { 492bd1 4e8d0436 6666660f1f840000000000 410fb60408 }
            // n = 4, score = 100
            //   492bd1               | dec                 eax
            //   4e8d0436             | lea                 ecx, [esp + 0x40]
            //   6666660f1f840000000000     | dec    ecx
            //   410fb60408           | sub                 eax, edx

        $sequence_64 = { 0fbe0d???????? 3bc1 7429 0fbe0d???????? 0fafcf 8d0449 }
            // n = 6, score = 100
            //   0fbe0d????????       |                     
            //   3bc1                 | mov                 eax, edi
            //   7429                 | xor                 edx, edx
            //   0fbe0d????????       |                     
            //   0fafcf               | dec                 eax
            //   8d0449               | mov                 ecx, eax

        $sequence_65 = { 0fbec8 0f57d2 0fbe05???????? 8d14d1 0fbe0d???????? 03c2 }
            // n = 6, score = 100
            //   0fbec8               | je                  0x1e7
            //   0f57d2               | dec                 eax
            //   0fbe05????????       |                     
            //   8d14d1               | arpl                word ptr [esp + 0x40], ax
            //   0fbe0d????????       |                     
            //   03c2                 | xor                 edx, edx

        $sequence_66 = { 4923c2 493bc3 7742 488bc2 4923c2 493bc3 }
            // n = 6, score = 100
            //   4923c2               | cmove               ecx, eax
            //   493bc3               | pop                 ebx
            //   7742                 | pop                 ebp
            //   488bc2               | ret                 
            //   4923c2               | mov                 eax, 0x5a4d
            //   493bc3               | cmp                 eax, -1

        $sequence_67 = { 83bc249400000003 0f9c442460 8b05???????? 8d4801 }
            // n = 4, score = 100
            //   83bc249400000003     | lea                 ecx, [ebp - 0x81]
            //   0f9c442460           | mov                 dword ptr [ebp - 4], esi
            //   8b05????????         |                     
            //   8d4801               | push                eax

        $sequence_68 = { 0f8c0d230000 488b7c2440 8b742450 488d0d1c700200 e8???????? 488d8d10030000 ff15???????? }
            // n = 7, score = 100
            //   0f8c0d230000         | cmp                 eax, ecx
            //   488b7c2440           | je                  0x2d
            //   8b742450             | imul                ecx, edi
            //   488d0d1c700200       | lea                 eax, [ecx + ecx*2]
            //   e8????????           |                     
            //   488d8d10030000       | jl                  0x2319
            //   ff15????????         |                     

        $sequence_69 = { 83bc24980000000e 0f9c442464 8b05???????? 8d4801 }
            // n = 4, score = 100
            //   83bc24980000000e     | cmp                 dword ptr [esp + 0x94], 3
            //   0f9c442464           | setl                byte ptr [esp + 0x60]
            //   8b05????????         |                     
            //   8d4801               | lea                 ecx, [eax + 1]

        $sequence_70 = { 83bc24980000000f b9fe4381ca b800af166b 0f4cc8 }
            // n = 4, score = 100
            //   83bc24980000000f     | cmp                 dword ptr [esp + 0x98], 0xe
            //   b9fe4381ca           | setl                byte ptr [esp + 0x64]
            //   b800af166b           | lea                 ecx, [eax + 1]
            //   0f4cc8               | imul                ecx, eax

    condition:
        7 of them and filesize < 4751360
}