rule win_virtualgate_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.virtualgate."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.virtualgate"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 418bc4 0f47c1 89442438 ffc8 8bf8 0fb68c82029a0100 }
            // n = 6, score = 100
            //   418bc4               | cmp                 byte ptr [eax + esi], ch
            //   0f47c1               | jne                 0x6a1
            //   89442438             | dec                 eax
            //   ffc8                 | lea                 eax, [ebp - 0x18]
            //   8bf8                 | dec                 eax
            //   0fb68c82029a0100     | mov                 dword ptr [ebp - 0x18], ecx

        $sequence_1 = { 66250100 7225 0100 7e25 0100 8a25???????? }
            // n = 6, score = 100
            //   66250100             | lea                 ecx, [0x1b900]
            //   7225                 | jmp                 0x681
            //   0100                 | cmp                 ecx, 1
            //   7e25                 | xor                 edx, edx
            //   0100                 | inc                 ecx
            //   8a25????????         |                     

        $sequence_2 = { 48894604 b906000000 48898620020000 0fb7c0 66f3ab 488d3d18470100 482bfe }
            // n = 7, score = 100
            //   48894604             | lea                 eax, [0x19388]
            //   b906000000           | and                 edx, 0x3f
            //   48898620020000       | dec                 eax
            //   0fb7c0               | lea                 edx, [edx + edx*8]
            //   66f3ab               | dec                 ecx
            //   488d3d18470100       | mov                 eax, dword ptr [eax + eax*8]
            //   482bfe               | test                byte ptr [eax + edx*8 + 0x38], 1

        $sequence_3 = { 85c0 0f8483000000 488d8510030000 49c7c0ffffffff 49ffc0 42383400 }
            // n = 6, score = 100
            //   85c0                 | dec                 eax
            //   0f8483000000         | mov                 eax, dword ptr [esp + 0x50]
            //   488d8510030000       | and                 dword ptr [eax + 0x3a8], 0xfffffffd
            //   49c7c0ffffffff       | jmp                 0xf07
            //   49ffc0               | inc                 esp
            //   42383400             | cmp                 byte ptr [ebp - 0x61], ch

        $sequence_4 = { 488d15263d0100 e8???????? 8bcb 4885c0 740c }
            // n = 5, score = 100
            //   488d15263d0100       | lea                 edx, [0xdf5f]
            //   e8????????           |                     
            //   8bcb                 | inc                 esp
            //   4885c0               | mov                 eax, esi
            //   740c                 | jmp                 0x204a

        $sequence_5 = { 488d0d30ecfeff 4c8945e7 4d03e8 48895df7 4c8be3 4c896db7 }
            // n = 6, score = 100
            //   488d0d30ecfeff       | dec                 eax
            //   4c8945e7             | mov                 eax, ebx
            //   4d03e8               | dec                 esp
            //   48895df7             | lea                 esi, [0x13b62]
            //   4c8be3               | and                 eax, 0x3f
            //   4c896db7             | dec                 eax

        $sequence_6 = { 85c0 0f8403010000 488d0566080100 4a8b04e8 42385cf838 0f8ded000000 }
            // n = 6, score = 100
            //   85c0                 | mov                 eax, ebp
            //   0f8403010000         | dec                 eax
            //   488d0566080100       | lea                 edx, [ebp - 0x59]
            //   4a8b04e8             | inc                 esp
            //   42385cf838           | cmp                 byte ptr [esp + 0x68], ch
            //   0f8ded000000         | je                  0xe98

        $sequence_7 = { 48895c2408 57 4883ec20 488d1d8fc60100 488d3d88c60100 }
            // n = 5, score = 100
            //   48895c2408           | mov                 eax, edi
            //   57                   | jmp                 0x10a1
            //   4883ec20             | dec                 eax
            //   488d1d8fc60100       | arpl                cx, dx
            //   488d3d88c60100       | dec                 esp

        $sequence_8 = { f30f6f0f 4883f80e 7773 8b848634270100 4803c6 }
            // n = 5, score = 100
            //   f30f6f0f             | dec                 eax
            //   4883f80e             | lea                 ecx, [0xf1c7]
            //   7773                 | and                 eax, 0x3f
            //   8b848634270100       | dec                 ebp
            //   4803c6               | mov                 edi, ebp

        $sequence_9 = { 4b8b8ce0f0250200 4803ca 48ffc2 468854f13e }
            // n = 4, score = 100
            //   4b8b8ce0f0250200     | mov                 edx, edi
            //   4803ca               | dec                 ecx
            //   48ffc2               | cmp                 eax, edi
            //   468854f13e           | dec                 esp

    condition:
        7 of them and filesize < 323584
}