rule win_void_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.void."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.void"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83e001 0f840c000000 8365ecfe 8d4db8 e9???????? c3 8d8dd4feffff }
            // n = 7, score = 200
            //   83e001               | and                 eax, 1
            //   0f840c000000         | je                  0x12
            //   8365ecfe             | and                 dword ptr [ebp - 0x14], 0xfffffffe
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8d8dd4feffff         | lea                 ecx, [ebp - 0x12c]

        $sequence_1 = { 8b4564 83e004 0f840c000000 836564fb 8d4dac e9???????? c3 }
            // n = 7, score = 200
            //   8b4564               | mov                 eax, dword ptr [ebp + 0x64]
            //   83e004               | and                 eax, 4
            //   0f840c000000         | je                  0x12
            //   836564fb             | and                 dword ptr [ebp + 0x64], 0xfffffffb
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   e9????????           |                     
            //   c3                   | ret                 

        $sequence_2 = { 6a02 8d4d48 e8???????? 8d4548 c745fc02000000 bb01000000 8bce }
            // n = 7, score = 200
            //   6a02                 | push                2
            //   8d4d48               | lea                 ecx, [ebp + 0x48]
            //   e8????????           |                     
            //   8d4548               | lea                 eax, [ebp + 0x48]
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   bb01000000           | mov                 ebx, 1
            //   8bce                 | mov                 ecx, esi

        $sequence_3 = { 7504 c645f301 8d4db8 c745fcffffffff e8???????? 807df300 0f8569060000 }
            // n = 7, score = 200
            //   7504                 | jne                 6
            //   c645f301             | mov                 byte ptr [ebp - 0xd], 1
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     
            //   807df300             | cmp                 byte ptr [ebp - 0xd], 0
            //   0f8569060000         | jne                 0x66f

        $sequence_4 = { 83e914 e9???????? 83e918 e9???????? 83e93c e9???????? 83e904 }
            // n = 7, score = 200
            //   83e914               | sub                 ecx, 0x14
            //   e9????????           |                     
            //   83e918               | sub                 ecx, 0x18
            //   e9????????           |                     
            //   83e93c               | sub                 ecx, 0x3c
            //   e9????????           |                     
            //   83e904               | sub                 ecx, 4

        $sequence_5 = { 50 8d4dd8 e8???????? 8d45d8 8d732c 50 8bce }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   8d732c               | lea                 esi, [ebx + 0x2c]
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi

        $sequence_6 = { 50 8bcf e8???????? 8d8d64ffffff c645fc0c e8???????? 33f6 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8d8d64ffffff         | lea                 ecx, [ebp - 0x9c]
            //   c645fc0c             | mov                 byte ptr [ebp - 4], 0xc
            //   e8????????           |                     
            //   33f6                 | xor                 esi, esi

        $sequence_7 = { 0f8510010000 8b85b8feffff 66c745840100 889d71ffffff c78578ffffff00000000 8b4004 8b8c05f0feffff }
            // n = 7, score = 200
            //   0f8510010000         | jne                 0x116
            //   8b85b8feffff         | mov                 eax, dword ptr [ebp - 0x148]
            //   66c745840100         | mov                 word ptr [ebp - 0x7c], 1
            //   889d71ffffff         | mov                 byte ptr [ebp - 0x8f], bl
            //   c78578ffffff00000000     | mov    dword ptr [ebp - 0x88], 0
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   8b8c05f0feffff       | mov                 ecx, dword ptr [ebp + eax - 0x110]

    condition:
        7 of them and filesize < 2744320
}