rule win_voidoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.voidoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.voidoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740d 83cb40 eb66 81cb80000000 eb5e 83cb20 eb59 }
            // n = 7, score = 100
            //   740d                 | je                  0xf
            //   83cb40               | or                  ebx, 0x40
            //   eb66                 | jmp                 0x68
            //   81cb80000000         | or                  ebx, 0x80
            //   eb5e                 | jmp                 0x60
            //   83cb20               | or                  ebx, 0x20
            //   eb59                 | jmp                 0x5b

        $sequence_1 = { 83c404 837c241000 7509 55 e8???????? 83c404 5b }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   837c241000           | cmp                 dword ptr [esp + 0x10], 0
            //   7509                 | jne                 0xb
            //   55                   | push                ebp
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   5b                   | pop                 ebx

        $sequence_2 = { c786a805000002000000 5e c3 83f901 74bf 68???????? 50 }
            // n = 7, score = 100
            //   c786a805000002000000     | mov    dword ptr [esi + 0x5a8], 2
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   83f901               | cmp                 ecx, 1
            //   74bf                 | je                  0xffffffc1
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_3 = { c7461807000000 eb36 803f0a 756d 47 83c3ff c7461807000000 }
            // n = 7, score = 100
            //   c7461807000000       | mov                 dword ptr [esi + 0x18], 7
            //   eb36                 | jmp                 0x38
            //   803f0a               | cmp                 byte ptr [edi], 0xa
            //   756d                 | jne                 0x6f
            //   47                   | inc                 edi
            //   83c3ff               | add                 ebx, -1
            //   c7461807000000       | mov                 dword ptr [esi + 0x18], 7

        $sequence_4 = { 0f8498000000 83f801 0f848f000000 83f8ff 0f8486000000 f6470c82 7551 }
            // n = 7, score = 100
            //   0f8498000000         | je                  0x9e
            //   83f801               | cmp                 eax, 1
            //   0f848f000000         | je                  0x95
            //   83f8ff               | cmp                 eax, -1
            //   0f8486000000         | je                  0x8c
            //   f6470c82             | test                byte ptr [edi + 0xc], 0x82
            //   7551                 | jne                 0x53

        $sequence_5 = { e8???????? 83c404 85c0 0f8547010000 817e782c010000 0f8cdc000000 39850c030000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f8547010000         | jne                 0x14d
            //   817e782c010000       | cmp                 dword ptr [esi + 0x78], 0x12c
            //   0f8cdc000000         | jl                  0xe2
            //   39850c030000         | cmp                 dword ptr [ebp + 0x30c], eax

        $sequence_6 = { ff33 ffd6 ff7304 ffd6 8b4c243c 5f 5e }
            // n = 7, score = 100
            //   ff33                 | push                dword ptr [ebx]
            //   ffd6                 | call                esi
            //   ff7304               | push                dword ptr [ebx + 4]
            //   ffd6                 | call                esi
            //   8b4c243c             | mov                 ecx, dword ptr [esp + 0x3c]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { e9???????? 8d8de8fdffff e9???????? 8d8d48feffff e9???????? 8b8d78fcffff e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8de8fdffff         | lea                 ecx, [ebp - 0x218]
            //   e9????????           |                     
            //   8d8d48feffff         | lea                 ecx, [ebp - 0x1b8]
            //   e9????????           |                     
            //   8b8d78fcffff         | mov                 ecx, dword ptr [ebp - 0x388]
            //   e9????????           |                     

        $sequence_8 = { c78424e005000001010101 c78424e405000001010101 66c78424e80500000100 33c9 8bff 8a848c08050000 3422 }
            // n = 7, score = 100
            //   c78424e005000001010101     | mov    dword ptr [esp + 0x5e0], 0x1010101
            //   c78424e405000001010101     | mov    dword ptr [esp + 0x5e4], 0x1010101
            //   66c78424e80500000100     | mov    word ptr [esp + 0x5e8], 1
            //   33c9                 | xor                 ecx, ecx
            //   8bff                 | mov                 edi, edi
            //   8a848c08050000       | mov                 al, byte ptr [esp + ecx*4 + 0x508]
            //   3422                 | xor                 al, 0x22

        $sequence_9 = { e9???????? 57 33ff 8bcf 894de4 8bc7 3998f8f14b00 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   8bcf                 | mov                 ecx, edi
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8bc7                 | mov                 eax, edi
            //   3998f8f14b00         | cmp                 dword ptr [eax + 0x4bf1f8], ebx

    condition:
        7 of them and filesize < 1744896
}