rule win_voldemort_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.voldemort."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.voldemort"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4803c1 48894308 e9???????? 48895c2408 }
            // n = 4, score = 300
            //   4803c1               | mov                 ebx, ecx
            //   48894308             | inc                 ecx
            //   e9????????           |                     
            //   48895c2408           | lea                 eax, [ebp - 1]

        $sequence_1 = { 48894308 e9???????? 48895c2408 57 }
            // n = 4, score = 300
            //   48894308             | dec                 esp
            //   e9????????           |                     
            //   48895c2408           | mov                 esp, esi
            //   57                   | dec                 eax

        $sequence_2 = { 418ac0 c3 488bc4 48895808 48896810 48897018 48897820 }
            // n = 7, score = 300
            //   418ac0               | movsd               qword ptr [esp + 0x80], xmm0
            //   c3                   | movaps              xmmword ptr [esp + 0x50], xmm1
            //   488bc4               | dec                 eax
            //   48895808             | mov                 dword ptr [esp + 0x28], ecx
            //   48896810             | dec                 eax
            //   48897018             | lea                 ecx, [esp + 0x190]
            //   48897820             | dec                 eax

        $sequence_3 = { 0f45c7 4803c1 48894308 e9???????? 48895c2408 57 4883ec20 }
            // n = 7, score = 300
            //   0f45c7               | dec                 eax
            //   4803c1               | sub                 esp, 0x38
            //   48894308             | mov                 edx, 0x1517e74c
            //   e9????????           |                     
            //   48895c2408           | dec                 eax
            //   57                   | sub                 esp, 0x38
            //   4883ec20             | mov                 edx, 0x95385e78

        $sequence_4 = { 488b5c2408 418ac0 c3 488bc4 }
            // n = 4, score = 300
            //   488b5c2408           | dec                 eax
            //   418ac0               | test                eax, eax
            //   c3                   | je                  0x17d1
            //   488bc4               | dec                 eax

        $sequence_5 = { 7597 41b001 488b5c2408 418ac0 c3 488bc4 }
            // n = 6, score = 300
            //   7597                 | test                eax, eax
            //   41b001               | movaps              xmmword ptr [esp + 0x90], xmm1
            //   488b5c2408           | movsd               qword ptr [esp + 0xa0], xmm0
            //   418ac0               | call                dword ptr [eax + 0x80]
            //   c3                   | dec                 eax
            //   488bc4               | lea                 ecx, [0x32597]

        $sequence_6 = { 488b5c2408 418ac0 c3 488bc4 48895808 48896810 48897018 }
            // n = 7, score = 300
            //   488b5c2408           | dec                 eax
            //   418ac0               | lea                 ecx, [0x384d5]
            //   c3                   | dec                 eax
            //   488bc4               | lea                 ecx, [0x38571]
            //   48895808             | dec                 eax
            //   48896810             | mov                 ebx, eax
            //   48897018             | dec                 eax

        $sequence_7 = { 8d78fe 0f45c7 4803c1 48894308 e9???????? 48895c2408 }
            // n = 6, score = 300
            //   8d78fe               | arpl                ax, bx
            //   0f45c7               | test                eax, eax
            //   4803c1               | jle                 0x188b
            //   48894308             | xor                 edx, edx
            //   e9????????           |                     
            //   48895c2408           | mov                 ecx, 0xfde9

        $sequence_8 = { 488b5c2408 418ac0 c3 488bc4 48895808 48896810 }
            // n = 6, score = 300
            //   488b5c2408           | cmovb               eax, edx
            //   418ac0               | or                  ax, 0xd800
            //   c3                   | or                  cx, 0xdc00
            //   488bc4               | inc                 cx
            //   48895808             | mov                 dword ptr [esi + edi*2], eax
            //   48896810             | inc                 cx

        $sequence_9 = { 5f c3 4c8bdc 49895b18 57 4883ec40 }
            // n = 6, score = 300
            //   5f                   | xor                 esi, esi
            //   c3                   | jmp                 0xfd4
            //   4c8bdc               | dec                 eax
            //   49895b18             | inc                 edi
            //   57                   | inc                 esp
            //   4883ec40             | cmp                 byte ptr [edi], ch

    condition:
        7 of them and filesize < 577536
}