rule win_vshell_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vshell."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vshell"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 90 bf01000000 90 e8???????? 488b942480000000 48894a70 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | inc                 esp
            //   bf01000000           | movzx               eax, byte ptr [esp + edx + 0x1d]
            //   90                   | inc                 ecx
            //   e8????????           |                     
            //   488b942480000000     | xor                 eax, esi
            //   48894a70             | dec                 eax

        $sequence_1 = { eb50 488b842498000000 48c740280b000000 eb3e 488b842428010000 488b9c2430010000 e8???????? }
            // n = 7, score = 100
            //   eb50                 | mov                 dword ptr [esp + 0x68], eax
            //   488b842498000000     | dec                 eax
            //   48c740280b000000     | lea                 eax, [0x437cee]
            //   eb3e                 | mov                 ecx, 6
            //   488b842428010000     | dec                 esp
            //   488b9c2430010000     | lea                 eax, [ebx + 2]
            //   e8????????           |                     

        $sequence_2 = { e8???????? 48c70019000000 e8???????? 4889c1 4889df 488d05419d5d00 488b9c2490000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48c70019000000       | mov                 ecx, dword ptr [esp + 0x38]
            //   e8????????           |                     
            //   4889c1               | mov                 eax, dword ptr [esp + 0x30]
            //   4889df               | dec                 eax
            //   488d05419d5d00       | mov                 ebx, dword ptr [esp + 0x48]
            //   488b9c2490000000     | xor                 eax, eax

        $sequence_3 = { eb1b 440fb64c3c27 418d3431 8d76cd 4088741427 4488443c27 4883c002 }
            // n = 7, score = 100
            //   eb1b                 | lea                 eax, [0x101a1c]
            //   440fb64c3c27         | mov                 ecx, 3
            //   418d3431             | dec                 esp
            //   8d76cd               | lea                 eax, [ebx + 4]
            //   4088741427           | dec                 esp
            //   4488443c27           | cmp                 esi, eax
            //   4883c002             | jae                 0x88

        $sequence_4 = { eb38 488b8c2488000000 488b4110 e8???????? 4889c3 488d053d4ca100 488b6c2478 }
            // n = 7, score = 100
            //   eb38                 | mov                 dword ptr [esp + 0x110], ebx
            //   488b8c2488000000     | dec                 eax
            //   488b4110             | lea                 ecx, [0x3bf8d0]
            //   e8????????           |                     
            //   4889c3               | mov                 ecx, 6
            //   488d053d4ca100       | dec                 eax
            //   488b6c2478           | mov                 dword ptr [esp + 0x118], eax

        $sequence_5 = { eba7 4885c9 741c 48894c2440 48899c2498000000 31c0 31d2 }
            // n = 7, score = 100
            //   eba7                 | cmp                 esi, eax
            //   4885c9               | jae                 0x6cd
            //   741c                 | dec                 eax
            //   48894c2440           | lea                 eax, [0x13eecb]
            //   48899c2498000000     | dec                 eax
            //   31c0                 | mov                 ecx, ebx
            //   31d2                 | mov                 ecx, 7

        $sequence_6 = { e8???????? e8???????? 4889842478040000 e8???????? 4889842470040000 48899c24d8010000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   4889842478040000     | dec                 eax
            //   e8????????           |                     
            //   4889842470040000     | mov                 eax, dword ptr [esp + 0xf0]
            //   48899c24d8010000     | dec                 eax
            //   e8????????           |                     

        $sequence_7 = { eb0c 488d3da654b000 e8???????? 4885db 7410 4889d8 4889cb }
            // n = 7, score = 100
            //   eb0c                 | nop                 
            //   488d3da654b000       | call                ecx
            //   e8????????           |                     
            //   4885db               | dec                 eax
            //   7410                 | mov                 ecx, dword ptr [eax]
            //   4889d8               | dec                 eax
            //   4889cb               | mov                 edx, eax

        $sequence_8 = { e8???????? eb38 488b7c2428 488b07 488b5f08 488b4f10 440f117f08 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb38                 | inc                 ecx
            //   488b7c2428           | and                 ecx, 7
            //   488b07               | dec                 ecx
            //   488b5f08             | mov                 ebx, ecx
            //   488b4f10             | nop                 
            //   440f117f08           | dec                 ecx

        $sequence_9 = { c744242c4e67d48a 48ba22266cf93b139a0b 4889542418 c74424206ecc42ee 31c0 eb1a 0fb6540424 }
            // n = 7, score = 100
            //   c744242c4e67d48a     | inc                 esp
            //   48ba22266cf93b139a0b     | movzx    eax, byte ptr [esp + 0x4d]
            //   4889542418           | mov                 byte ptr [eax + 0xd], dl
            //   c74424206ecc42ee     | movzx               edx, byte ptr [esp + 0x52]
            //   31c0                 | inc                 esp
            //   eb1a                 | movzx               eax, byte ptr [esp + 0x47]
            //   0fb6540424           | inc                 esp

    condition:
        7 of them and filesize < 39452672
}