rule win_vskimmer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vskimmer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vskimmer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb74624 6685c0 7413 50 ff75fc 8d8f2c020000 }
            // n = 6, score = 100
            //   0fb74624             | movzx               eax, word ptr [esi + 0x24]
            //   6685c0               | test                ax, ax
            //   7413                 | je                  0x15
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8d8f2c020000         | lea                 ecx, [edi + 0x22c]

        $sequence_1 = { 8d8dd4f7ffff e8???????? 83bdccf7ffff10 8b85b8f7ffff c645fc11 7306 }
            // n = 6, score = 100
            //   8d8dd4f7ffff         | lea                 ecx, [ebp - 0x82c]
            //   e8????????           |                     
            //   83bdccf7ffff10       | cmp                 dword ptr [ebp - 0x834], 0x10
            //   8b85b8f7ffff         | mov                 eax, dword ptr [ebp - 0x848]
            //   c645fc11             | mov                 byte ptr [ebp - 4], 0x11
            //   7306                 | jae                 8

        $sequence_2 = { 7629 8d7e04 ff75e8 ff37 ff15???????? 85c0 }
            // n = 6, score = 100
            //   7629                 | jbe                 0x2b
            //   8d7e04               | lea                 edi, [esi + 4]
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ff37                 | push                dword ptr [edi]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { c645fc0a ff15???????? 3bc7 0f8eeb030000 bb???????? be???????? 8d85f0f7ffff }
            // n = 7, score = 100
            //   c645fc0a             | mov                 byte ptr [ebp - 4], 0xa
            //   ff15????????         |                     
            //   3bc7                 | cmp                 eax, edi
            //   0f8eeb030000         | jle                 0x3f1
            //   bb????????           |                     
            //   be????????           |                     
            //   8d85f0f7ffff         | lea                 eax, [ebp - 0x810]

        $sequence_4 = { 8b8324020000 8bc8 81e101010000 83f901 0f84e1020000 }
            // n = 5, score = 100
            //   8b8324020000         | mov                 eax, dword ptr [ebx + 0x224]
            //   8bc8                 | mov                 ecx, eax
            //   81e101010000         | and                 ecx, 0x101
            //   83f901               | cmp                 ecx, 1
            //   0f84e1020000         | je                  0x2e7

        $sequence_5 = { 3b8314020000 0f84cc010000 56 8bcb }
            // n = 4, score = 100
            //   3b8314020000         | cmp                 eax, dword ptr [ebx + 0x214]
            //   0f84cc010000         | je                  0x1d2
            //   56                   | push                esi
            //   8bcb                 | mov                 ecx, ebx

        $sequence_6 = { e8???????? 83c418 8d85b4feffff 50 8d8d88f6ffff }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8d85b4feffff         | lea                 eax, [ebp - 0x14c]
            //   50                   | push                eax
            //   8d8d88f6ffff         | lea                 ecx, [ebp - 0x978]

        $sequence_7 = { 8d85ecfeffff 68???????? 50 e8???????? ffb5c4f8ffff 8d85ecfeffff }
            // n = 6, score = 100
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   ffb5c4f8ffff         | push                dword ptr [ebp - 0x73c]
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]

        $sequence_8 = { 33c0 8945f0 394510 7417 c706???????? c74610c4d54100 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   394510               | cmp                 dword ptr [ebp + 0x10], eax
            //   7417                 | je                  0x19
            //   c706????????         |                     
            //   c74610c4d54100       | mov                 dword ptr [esi + 0x10], 0x41d5c4

        $sequence_9 = { 59 c3 8bff 55 8bec 51 f6430c40 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   f6430c40             | test                byte ptr [ebx + 0xc], 0x40

    condition:
        7 of them and filesize < 376832
}