rule win_vx_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.vx_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vx_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45f4 64a300000000 8bf1 8b1d???????? c70600000000 c7461400000000 85db }
            // n = 7, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf1                 | mov                 esi, ecx
            //   8b1d????????         |                     
            //   c70600000000         | mov                 dword ptr [esi], 0
            //   c7461400000000       | mov                 dword ptr [esi + 0x14], 0
            //   85db                 | test                ebx, ebx

        $sequence_1 = { 8b0d???????? 8bd3 ff7608 6a32 50 }
            // n = 5, score = 100
            //   8b0d????????         |                     
            //   8bd3                 | mov                 edx, ebx
            //   ff7608               | push                dword ptr [esi + 8]
            //   6a32                 | push                0x32
            //   50                   | push                eax

        $sequence_2 = { e9???????? d9ee 84cd 0f84d2ae0000 d9e0 e9???????? ddd8 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   d9ee                 | fldz                
            //   84cd                 | test                ch, cl
            //   0f84d2ae0000         | je                  0xaed8
            //   d9e0                 | fchs                
            //   e9????????           |                     
            //   ddd8                 | fstp                st(0)

        $sequence_3 = { a1???????? 833c0700 7518 6a28 e8???????? 8b0d???????? 83c404 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   833c0700             | cmp                 dword ptr [edi + eax], 0
            //   7518                 | jne                 0x1a
            //   6a28                 | push                0x28
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   83c404               | add                 esp, 4

        $sequence_4 = { 8b45b8 03c0 c78540fdffff07000000 6889000000 }
            // n = 4, score = 100
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   03c0                 | add                 eax, eax
            //   c78540fdffff07000000     | mov    dword ptr [ebp - 0x2c0], 7
            //   6889000000           | push                0x89

        $sequence_5 = { 8bca c1f906 83e23f 6bd238 8b0c8d10df4300 88441129 }
            // n = 6, score = 100
            //   8bca                 | mov                 ecx, edx
            //   c1f906               | sar                 ecx, 6
            //   83e23f               | and                 edx, 0x3f
            //   6bd238               | imul                edx, edx, 0x38
            //   8b0c8d10df4300       | mov                 ecx, dword ptr [ecx*4 + 0x43df10]
            //   88441129             | mov                 byte ptr [ecx + edx + 0x29], al

        $sequence_6 = { 8b048510df4300 f644082801 7406 8b440818 5d }
            // n = 5, score = 100
            //   8b048510df4300       | mov                 eax, dword ptr [eax*4 + 0x43df10]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7406                 | je                  8
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]
            //   5d                   | pop                 ebp

        $sequence_7 = { 8b4ddc 8b45e8 8b0c8d10df4300 f644082804 7416 8a45ec }
            // n = 6, score = 100
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b0c8d10df4300       | mov                 ecx, dword ptr [ecx*4 + 0x43df10]
            //   f644082804           | test                byte ptr [eax + ecx + 0x28], 4
            //   7416                 | je                  0x18
            //   8a45ec               | mov                 al, byte ptr [ebp - 0x14]

        $sequence_8 = { 55 8bec 8b4510 56 8b750c 8b0e 3b0c8514e24300 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   3b0c8514e24300       | cmp                 ecx, dword ptr [eax*4 + 0x43e214]

        $sequence_9 = { 68e0070000 57 e8???????? ffb5d8f7ffff eb0c 68e0070000 }
            // n = 6, score = 100
            //   68e0070000           | push                0x7e0
            //   57                   | push                edi
            //   e8????????           |                     
            //   ffb5d8f7ffff         | push                dword ptr [ebp - 0x828]
            //   eb0c                 | jmp                 0xe
            //   68e0070000           | push                0x7e0

    condition:
        7 of them and filesize < 550912
}