rule win_w32times_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.w32times."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.w32times"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d44240c 6a00 50 53 57 56 c744242000000000 }
            // n = 7, score = 200
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi
            //   c744242000000000     | mov                 dword ptr [esp + 0x20], 0

        $sequence_1 = { 6a03 55 6a01 8d8c2410080000 6800000080 }
            // n = 5, score = 200
            //   6a03                 | push                3
            //   55                   | push                ebp
            //   6a01                 | push                1
            //   8d8c2410080000       | lea                 ecx, [esp + 0x810]
            //   6800000080           | push                0x80000000

        $sequence_2 = { 51 ffd6 8b4500 8d54242c }
            // n = 4, score = 200
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   8d54242c             | lea                 edx, [esp + 0x2c]

        $sequence_3 = { 8bcd 4f c1e902 f3a5 8bcd 8d9424ec010000 83e103 }
            // n = 7, score = 200
            //   8bcd                 | mov                 ecx, ebp
            //   4f                   | dec                 edi
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bcd                 | mov                 ecx, ebp
            //   8d9424ec010000       | lea                 edx, [esp + 0x1ec]
            //   83e103               | and                 ecx, 3

        $sequence_4 = { 3b9c24000d0000 0f84cc090000 8a8424f0020000 84c0 0f84bd090000 8a8424e8000000 84c0 }
            // n = 7, score = 200
            //   3b9c24000d0000       | cmp                 ebx, dword ptr [esp + 0xd00]
            //   0f84cc090000         | je                  0x9d2
            //   8a8424f0020000       | mov                 al, byte ptr [esp + 0x2f0]
            //   84c0                 | test                al, al
            //   0f84bd090000         | je                  0x9c3
            //   8a8424e8000000       | mov                 al, byte ptr [esp + 0xe8]
            //   84c0                 | test                al, al

        $sequence_5 = { 7534 8b2d???????? 46 56 68???????? }
            // n = 5, score = 200
            //   7534                 | jne                 0x36
            //   8b2d????????         |                     
            //   46                   | inc                 esi
            //   56                   | push                esi
            //   68????????           |                     

        $sequence_6 = { 8bd8 ffd7 56 ffd7 53 ff15???????? }
            // n = 6, score = 200
            //   8bd8                 | mov                 ebx, eax
            //   ffd7                 | call                edi
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_7 = { ebd7 68???????? ff15???????? 8b1d???????? 68???????? ff15???????? 85db }
            // n = 7, score = 200
            //   ebd7                 | jmp                 0xffffffd9
            //   68????????           |                     
            //   ff15????????         |                     
            //   8b1d????????         |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   85db                 | test                ebx, ebx

        $sequence_8 = { b941000000 bf???????? f3ab b941000000 8dbc24f8050000 }
            // n = 5, score = 200
            //   b941000000           | mov                 ecx, 0x41
            //   bf????????           |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   b941000000           | mov                 ecx, 0x41
            //   8dbc24f8050000       | lea                 edi, [esp + 0x5f8]

        $sequence_9 = { 83c40c 85c0 0f85e00c0000 8b4b04 6a04 }
            // n = 5, score = 200
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f85e00c0000         | jne                 0xce6
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]
            //   6a04                 | push                4

    condition:
        7 of them and filesize < 122880
}