rule win_wannacryptor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wannacryptor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wannacryptor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 7403 8b4004 50 8b442428 }
            // n = 6, score = 700
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   50                   | push                eax
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]

        $sequence_1 = { c744243802000000 e8???????? 55 8d4c2420 b303 50 51 }
            // n = 7, score = 700
            //   c744243802000000     | mov                 dword ptr [esp + 0x38], 2
            //   e8????????           |                     
            //   55                   | push                ebp
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   b303                 | mov                 bl, 3
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_2 = { 8d7e44 85c0 755f 8b17 8d4c241c 6a01 51 }
            // n = 7, score = 700
            //   8d7e44               | lea                 edi, [esi + 0x44]
            //   85c0                 | test                eax, eax
            //   755f                 | jne                 0x61
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   6a01                 | push                1
            //   51                   | push                ecx

        $sequence_3 = { 7d0d 8b5168 8b7960 03d7 }
            // n = 4, score = 700
            //   7d0d                 | jge                 0xf
            //   8b5168               | mov                 edx, dword ptr [ecx + 0x68]
            //   8b7960               | mov                 edi, dword ptr [ecx + 0x60]
            //   03d7                 | add                 edx, edi

        $sequence_4 = { c644243404 e8???????? 8d4c241c 885c2430 }
            // n = 4, score = 700
            //   c644243404           | mov                 byte ptr [esp + 0x34], 4
            //   e8????????           |                     
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   885c2430             | mov                 byte ptr [esp + 0x30], bl

        $sequence_5 = { 8d542418 c744243005000000 8b41f8 8b4e74 2bc1 }
            // n = 5, score = 700
            //   8d542418             | lea                 edx, [esp + 0x18]
            //   c744243005000000     | mov                 dword ptr [esp + 0x30], 5
            //   8b41f8               | mov                 eax, dword ptr [ecx - 8]
            //   8b4e74               | mov                 ecx, dword ptr [esi + 0x74]
            //   2bc1                 | sub                 eax, ecx

        $sequence_6 = { 8a02 8bcf 88442418 e8???????? 8b542410 c744243000000000 }
            // n = 6, score = 700
            //   8a02                 | mov                 al, byte ptr [edx]
            //   8bcf                 | mov                 ecx, edi
            //   88442418             | mov                 byte ptr [esp + 0x18], al
            //   e8????????           |                     
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   c744243000000000     | mov                 dword ptr [esp + 0x30], 0

        $sequence_7 = { c7442430ffffffff e8???????? e9???????? 85c0 754b }
            // n = 5, score = 700
            //   c7442430ffffffff     | mov                 dword ptr [esp + 0x30], 0xffffffff
            //   e8????????           |                     
            //   e9????????           |                     
            //   85c0                 | test                eax, eax
            //   754b                 | jne                 0x4d

        $sequence_8 = { 88442418 e8???????? 8b542410 c744243000000000 52 50 8d442420 }
            // n = 7, score = 700
            //   88442418             | mov                 byte ptr [esp + 0x18], al
            //   e8????????           |                     
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   c744243000000000     | mov                 dword ptr [esp + 0x30], 0
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d442420             | lea                 eax, [esp + 0x20]

        $sequence_9 = { 89442418 0f8c42ffffff 8b442438 5f 85c0 }
            // n = 5, score = 700
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   0f8c42ffffff         | jl                  0xffffff48
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   5f                   | pop                 edi
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 540672
}