rule win_wannahusky_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wannahusky."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wannahusky"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c605????????02 c705????????60b04100 c705????????18000000 c705????????04000000 }
            // n = 4, score = 100
            //   c605????????02       |                     
            //   c705????????60b04100     |     
            //   c705????????18000000     |     
            //   c705????????04000000     |     

        $sequence_1 = { 7408 8bbdf0faffff 8b0f 89442404 }
            // n = 4, score = 100
            //   7408                 | je                  0xa
            //   8bbdf0faffff         | mov                 edi, dword ptr [ebp - 0x510]
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   89442404             | mov                 dword ptr [esp + 4], eax

        $sequence_2 = { ba28020000 8d8d98fbffff e8???????? 8d8500fbffff c744240810000000 }
            // n = 5, score = 100
            //   ba28020000           | mov                 edx, 0x228
            //   8d8d98fbffff         | lea                 ecx, [ebp - 0x468]
            //   e8????????           |                     
            //   8d8500fbffff         | lea                 eax, [ebp - 0x500]
            //   c744240810000000     | mov                 dword ptr [esp + 8], 0x10

        $sequence_3 = { 83c008 c744240401000000 890424 ff15???????? 89ca }
            // n = 5, score = 100
            //   83c008               | add                 eax, 8
            //   c744240401000000     | mov                 dword ptr [esp + 4], 1
            //   890424               | mov                 dword ptr [esp], eax
            //   ff15????????         |                     
            //   89ca                 | mov                 edx, ecx

        $sequence_4 = { c705????????04000000 c705????????a0464200 c705????????e01c4100 c705????????f0b34100 c705????????00000000 }
            // n = 5, score = 100
            //   c705????????04000000     |     
            //   c705????????a0464200     |     
            //   c705????????e01c4100     |     
            //   c705????????f0b34100     |     
            //   c705????????00000000     |     

        $sequence_5 = { c705????????04000000 66c705????????2b03 c705????????18000000 c705????????04000000 c605????????11 c705????????80bb4100 }
            // n = 6, score = 100
            //   c705????????04000000     |     
            //   66c705????????2b03     |     
            //   c705????????18000000     |     
            //   c705????????04000000     |     
            //   c605????????11       |                     
            //   c705????????80bb4100     |     

        $sequence_6 = { c785fcfaffff00000000 8b480c e8???????? ba01000000 8d8dfcfaffff 8985fcfaffff e8???????? }
            // n = 7, score = 100
            //   c785fcfaffff00000000     | mov    dword ptr [ebp - 0x504], 0
            //   8b480c               | mov                 ecx, dword ptr [eax + 0xc]
            //   e8????????           |                     
            //   ba01000000           | mov                 edx, 1
            //   8d8dfcfaffff         | lea                 ecx, [ebp - 0x504]
            //   8985fcfaffff         | mov                 dword ptr [ebp - 0x504], eax
            //   e8????????           |                     

        $sequence_7 = { e8???????? 8b45cc 3b45c0 7218 8b7dc0 890424 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   3b45c0               | cmp                 eax, dword ptr [ebp - 0x40]
            //   7218                 | jb                  0x1a
            //   8b7dc0               | mov                 edi, dword ptr [ebp - 0x40]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_8 = { 56 53 83ec6c 8955c0 807d0800 ba???????? }
            // n = 6, score = 100
            //   56                   | push                esi
            //   53                   | push                ebx
            //   83ec6c               | sub                 esp, 0x6c
            //   8955c0               | mov                 dword ptr [ebp - 0x40], edx
            //   807d0800             | cmp                 byte ptr [ebp + 8], 0
            //   ba????????           |                     

        $sequence_9 = { c705????????08b44100 c705????????00000000 c705????????04000000 c705????????04000000 66c705????????1903 c605????????01 }
            // n = 6, score = 100
            //   c705????????08b44100     |     
            //   c705????????00000000     |     
            //   c705????????04000000     |     
            //   c705????????04000000     |     
            //   66c705????????1903     |     
            //   c605????????01       |                     

    condition:
        7 of them and filesize < 862208
}