rule win_warezov_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.warezov."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.warezov"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a8c04cc000000 8a9404fc000000 02d1 8a8c04fd000000 889404fc000000 8a9404cd000000 02ca }
            // n = 7, score = 100
            //   8a8c04cc000000       | mov                 cl, byte ptr [esp + eax + 0xcc]
            //   8a9404fc000000       | mov                 dl, byte ptr [esp + eax + 0xfc]
            //   02d1                 | add                 dl, cl
            //   8a8c04fd000000       | mov                 cl, byte ptr [esp + eax + 0xfd]
            //   889404fc000000       | mov                 byte ptr [esp + eax + 0xfc], dl
            //   8a9404cd000000       | mov                 dl, byte ptr [esp + eax + 0xcd]
            //   02ca                 | add                 cl, dl

        $sequence_1 = { c68424a300000065 c68424a400000062 c68424a500000075 c68424a600000070 c68424a700000077 889c24a8000000 c68424ad00000070 }
            // n = 7, score = 100
            //   c68424a300000065     | mov                 byte ptr [esp + 0xa3], 0x65
            //   c68424a400000062     | mov                 byte ptr [esp + 0xa4], 0x62
            //   c68424a500000075     | mov                 byte ptr [esp + 0xa5], 0x75
            //   c68424a600000070     | mov                 byte ptr [esp + 0xa6], 0x70
            //   c68424a700000077     | mov                 byte ptr [esp + 0xa7], 0x77
            //   889c24a8000000       | mov                 byte ptr [esp + 0xa8], bl
            //   c68424ad00000070     | mov                 byte ptr [esp + 0xad], 0x70

        $sequence_2 = { ffd3 50 ff15???????? 85c0 8b942430010000 8902 7531 }
            // n = 7, score = 100
            //   ffd3                 | call                ebx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   8b942430010000       | mov                 edx, dword ptr [esp + 0x130]
            //   8902                 | mov                 dword ptr [edx], eax
            //   7531                 | jne                 0x33

        $sequence_3 = { 8d8c24a8000000 51 6a00 68???????? 8d9424b8010000 52 }
            // n = 6, score = 100
            //   8d8c24a8000000       | lea                 ecx, [esp + 0xa8]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   68????????           |                     
            //   8d9424b8010000       | lea                 edx, [esp + 0x1b8]
            //   52                   | push                edx

        $sequence_4 = { c684243801000039 c6842439010000ac c684243a0100000f c684243b010000fe c684243c01000046 c684243d0100006a c684243e01000038 }
            // n = 7, score = 100
            //   c684243801000039     | mov                 byte ptr [esp + 0x138], 0x39
            //   c6842439010000ac     | mov                 byte ptr [esp + 0x139], 0xac
            //   c684243a0100000f     | mov                 byte ptr [esp + 0x13a], 0xf
            //   c684243b010000fe     | mov                 byte ptr [esp + 0x13b], 0xfe
            //   c684243c01000046     | mov                 byte ptr [esp + 0x13c], 0x46
            //   c684243d0100006a     | mov                 byte ptr [esp + 0x13d], 0x6a
            //   c684243e01000038     | mov                 byte ptr [esp + 0x13e], 0x38

        $sequence_5 = { 885e14 8b5008 56 8bcd 885a14 e8???????? eb78 }
            // n = 7, score = 100
            //   885e14               | mov                 byte ptr [esi + 0x14], bl
            //   8b5008               | mov                 edx, dword ptr [eax + 8]
            //   56                   | push                esi
            //   8bcd                 | mov                 ecx, ebp
            //   885a14               | mov                 byte ptr [edx + 0x14], bl
            //   e8????????           |                     
            //   eb78                 | jmp                 0x7a

        $sequence_6 = { 0473 b142 f6e9 8ad8 8b06 80eb12 80cbcd }
            // n = 7, score = 100
            //   0473                 | add                 al, 0x73
            //   b142                 | mov                 cl, 0x42
            //   f6e9                 | imul                cl
            //   8ad8                 | mov                 bl, al
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   80eb12               | sub                 bl, 0x12
            //   80cbcd               | or                  bl, 0xcd

        $sequence_7 = { 33f6 4d 85ed ba77000000 7e50 8b74240c 53 }
            // n = 7, score = 100
            //   33f6                 | xor                 esi, esi
            //   4d                   | dec                 ebp
            //   85ed                 | test                ebp, ebp
            //   ba77000000           | mov                 edx, 0x77
            //   7e50                 | jle                 0x52
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]
            //   53                   | push                ebx

        $sequence_8 = { 32ca 888c049c020000 40 83f809 7ce3 8d8424a8020000 50 }
            // n = 7, score = 100
            //   32ca                 | xor                 cl, dl
            //   888c049c020000       | mov                 byte ptr [esp + eax + 0x29c], cl
            //   40                   | inc                 eax
            //   83f809               | cmp                 eax, 9
            //   7ce3                 | jl                  0xffffffe5
            //   8d8424a8020000       | lea                 eax, [esp + 0x2a8]
            //   50                   | push                eax

        $sequence_9 = { c68424aa000000d3 c68424ab000000b8 c68424ac000000a9 c68424ad0000002e c68424ae00000049 c68424af00000041 }
            // n = 6, score = 100
            //   c68424aa000000d3     | mov                 byte ptr [esp + 0xaa], 0xd3
            //   c68424ab000000b8     | mov                 byte ptr [esp + 0xab], 0xb8
            //   c68424ac000000a9     | mov                 byte ptr [esp + 0xac], 0xa9
            //   c68424ad0000002e     | mov                 byte ptr [esp + 0xad], 0x2e
            //   c68424ae00000049     | mov                 byte ptr [esp + 0xae], 0x49
            //   c68424af00000041     | mov                 byte ptr [esp + 0xaf], 0x41

    condition:
        7 of them and filesize < 827392
}