rule win_warhawk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.warhawk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.warhawk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8be5 5d c3 bb02000000 8b4dfc 8bc3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   bb02000000           | mov                 ebx, 2
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8bc3                 | mov                 eax, ebx

        $sequence_1 = { 83f809 0f8799000000 ff248521b34000 ff7510 ff750c e8???????? }
            // n = 6, score = 100
            //   83f809               | cmp                 eax, 9
            //   0f8799000000         | ja                  0x9f
            //   ff248521b34000       | jmp                 dword ptr [eax*4 + 0x40b321]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     

        $sequence_2 = { 0f8482000000 53 57 6a28 ff15???????? 8bd8 83c404 }
            // n = 7, score = 100
            //   0f8482000000         | je                  0x88
            //   53                   | push                ebx
            //   57                   | push                edi
            //   6a28                 | push                0x28
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   83c404               | add                 esp, 4

        $sequence_3 = { 0f8473010000 8d85fcfbffff 8d5001 660f1f440000 8a08 40 84c9 }
            // n = 7, score = 100
            //   0f8473010000         | je                  0x179
            //   8d85fcfbffff         | lea                 eax, [ebp - 0x404]
            //   8d5001               | lea                 edx, [eax + 1]
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl

        $sequence_4 = { 0fb606 50 e8???????? 0fb60b }
            // n = 4, score = 100
            //   0fb606               | movzx               eax, byte ptr [esi]
            //   50                   | push                eax
            //   e8????????           |                     
            //   0fb60b               | movzx               ecx, byte ptr [ebx]

        $sequence_5 = { e711 a0???????? ad fb 93 9f b66c }
            // n = 7, score = 100
            //   e711                 | out                 0x11, eax
            //   a0????????           |                     
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   fb                   | sti                 
            //   93                   | xchg                eax, ebx
            //   9f                   | lahf                
            //   b66c                 | mov                 dh, 0x6c

        $sequence_6 = { 85c9 7406 8b4204 894104 8b4e08 3bd1 }
            // n = 6, score = 100
            //   85c9                 | test                ecx, ecx
            //   7406                 | je                  8
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   894104               | mov                 dword ptr [ecx + 4], eax
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   3bd1                 | cmp                 edx, ecx

        $sequence_7 = { 8b7d0c 33db 897df4 8975f8 8945fc 8a06 3a8358e94100 }
            // n = 7, score = 100
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   33db                 | xor                 ebx, ebx
            //   897df4               | mov                 dword ptr [ebp - 0xc], edi
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8a06                 | mov                 al, byte ptr [esi]
            //   3a8358e94100         | cmp                 al, byte ptr [ebx + 0x41e958]

        $sequence_8 = { 0fb680201c4000 ff2485001c4000 c6065c eb30 c60622 eb2b c60662 }
            // n = 7, score = 100
            //   0fb680201c4000       | movzx               eax, byte ptr [eax + 0x401c20]
            //   ff2485001c4000       | jmp                 dword ptr [eax*4 + 0x401c00]
            //   c6065c               | mov                 byte ptr [esi], 0x5c
            //   eb30                 | jmp                 0x32
            //   c60622               | mov                 byte ptr [esi], 0x22
            //   eb2b                 | jmp                 0x2d
            //   c60662               | mov                 byte ptr [esi], 0x62

        $sequence_9 = { 660f2fda 0f93c0 85c0 754d }
            // n = 4, score = 100
            //   660f2fda             | comisd              xmm3, xmm2
            //   0f93c0               | setae               al
            //   85c0                 | test                eax, eax
            //   754d                 | jne                 0x4f

    condition:
        7 of them and filesize < 2345984
}