rule win_wastedlocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wastedlocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wastedlocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a2a e8???????? 8b45fc 8b30 }
            // n = 4, score = 1000
            //   6a2a                 | push                0x2a
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b30                 | mov                 esi, dword ptr [eax]

        $sequence_1 = { 5b 7504 8365fc00 8b4508 ff30 ff15???????? 8b45fc }
            // n = 7, score = 1000
            //   5b                   | pop                 ebx
            //   7504                 | jne                 6
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff30                 | push                dword ptr [eax]
            //   ff15????????         |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_2 = { 8bc7 351ec34eee 50 53 e8???????? }
            // n = 5, score = 1000
            //   8bc7                 | mov                 eax, edi
            //   351ec34eee           | xor                 eax, 0xee4ec31e
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_3 = { ff15???????? 85c0 740f 6a02 57 ff15???????? }
            // n = 6, score = 1000
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   6a02                 | push                2
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_4 = { 51 8935???????? 8935???????? a3???????? a3???????? }
            // n = 5, score = 1000
            //   51                   | push                ecx
            //   8935????????         |                     
            //   8935????????         |                     
            //   a3????????           |                     
            //   a3????????           |                     

        $sequence_5 = { e8???????? 8d85d0f3ffff 50 56 8d85b8edffff 50 8d85b0ebffff }
            // n = 7, score = 1000
            //   e8????????           |                     
            //   8d85d0f3ffff         | lea                 eax, [ebp - 0xc30]
            //   50                   | push                eax
            //   56                   | push                esi
            //   8d85b8edffff         | lea                 eax, [ebp - 0x1248]
            //   50                   | push                eax
            //   8d85b0ebffff         | lea                 eax, [ebp - 0x1450]

        $sequence_6 = { 8918 33f6 eb26 ff15???????? 53 6a00 ff35???????? }
            // n = 7, score = 1000
            //   8918                 | mov                 dword ptr [eax], ebx
            //   33f6                 | xor                 esi, esi
            //   eb26                 | jmp                 0x28
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   ff35????????         |                     

        $sequence_7 = { 03c7 13cb a3???????? 0bc1 890d???????? 0f8456010000 8b4dfc }
            // n = 7, score = 1000
            //   03c7                 | add                 eax, edi
            //   13cb                 | adc                 ecx, ebx
            //   a3????????           |                     
            //   0bc1                 | or                  eax, ecx
            //   890d????????         |                     
            //   0f8456010000         | je                  0x15c
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_8 = { ff7508 e8???????? 2b4d08 8bf0 03f1 eb02 8bf1 }
            // n = 7, score = 1000
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   2b4d08               | sub                 ecx, dword ptr [ebp + 8]
            //   8bf0                 | mov                 esi, eax
            //   03f1                 | add                 esi, ecx
            //   eb02                 | jmp                 4
            //   8bf1                 | mov                 esi, ecx

        $sequence_9 = { ff750c 6a00 ff35???????? ff15???????? 8b45f0 5f 5e }
            // n = 7, score = 1000
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   6a00                 | push                0
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 147456
}