rule win_waterminer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.waterminer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.waterminer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 6804100020 8b5508 52 }
            // n = 4, score = 100
            //   51                   | add                 edi, dword ptr [esp + 0xa8]
            //   6804100020           | dec                 eax
            //   8b5508               | mov                 ecx, ebp
            //   52                   | dec                 esp

        $sequence_1 = { 8b9584fdffff 0fb68208794400 ff2485f0784400 8b8decfdffff 83c904 898decfdffff }
            // n = 6, score = 100
            //   8b9584fdffff         | sub                 ecx, eax
            //   0fb68208794400       | je                  0x4f4
            //   ff2485f0784400       | lea                 eax, [ecx - 1]
            //   8b8decfdffff         | mov                 eax, dword ptr [edx + eax*4 + 0x6d288]
            //   83c904               | test                eax, eax
            //   898decfdffff         | add                 eax, eax

        $sequence_2 = { 03bc24a8000000 488bcd 4c8d0d35cb0300 83e13f }
            // n = 4, score = 100
            //   03bc24a8000000       | inc                 ecx
            //   488bcd               | mov                 eax, dword ptr [eax + eax]
            //   4c8d0d35cb0300       | add                 eax, dword ptr [esp + 0xc]
            //   83e13f               | inc                 esp

        $sequence_3 = { b804000000 6bc014 8b8880434b00 330d???????? 894dfc }
            // n = 5, score = 100
            //   b804000000           | sub                 ecx, eax
            //   6bc014               | je                  0x4f4
            //   8b8880434b00         | lea                 eax, [ecx - 1]
            //   330d????????         |                     
            //   894dfc               | mov                 eax, dword ptr [edx + eax*4 + 0x6d288]

        $sequence_4 = { 02d0 49ffc3 418d4001 881418 }
            // n = 4, score = 100
            //   02d0                 | inc                 ecx
            //   49ffc3               | mov                 byte ptr [eax + ebx], cl
            //   418d4001             | inc                 ecx
            //   881418               | mov                 al, byte ptr [ebx]

        $sequence_5 = { 8d8518f5ffff 50 e8???????? 83c404 898500f7ffff e8???????? 85c0 }
            // n = 7, score = 100
            //   8d8518f5ffff         | mov                 eax, ebp
            //   50                   | dec                 eax
            //   e8????????           |                     
            //   83c404               | sar                 eax, 6
            //   898500f7ffff         | dec                 eax
            //   e8????????           |                     
            //   85c0                 | shl                 ecx, 6

        $sequence_6 = { 0344240c 4403d0 428b4405e7 418bd2 }
            // n = 4, score = 100
            //   0344240c             | cmp                 ecx, edx
            //   4403d0               | add                 dl, al
            //   428b4405e7           | dec                 ecx
            //   418bd2               | inc                 ebx

        $sequence_7 = { 03442410 4403e8 428b4405e7 418bd5 }
            // n = 4, score = 100
            //   03442410             | dec                 esp
            //   4403e8               | lea                 eax, [0x55894]
            //   428b4405e7           | inc                 ecx
            //   418bd5               | xor                 edx, ebp

        $sequence_8 = { 03c1 03d0 488d051e580500 418b0400 }
            // n = 4, score = 100
            //   03c1                 | lea                 eax, [0x5579f]
            //   03d0                 | inc                 ebx
            //   488d051e580500       | xor                 eax, dword ptr [ecx + eax]
            //   418b0400             | add                 eax, dword ptr [esp + 0x10]

        $sequence_9 = { 6bc903 898180434b00 68???????? 8b55fc 52 }
            // n = 5, score = 100
            //   6bc903               | lea                 ecx, [0x3cb35]
            //   898180434b00         | and                 ecx, 0x3f
            //   68????????           |                     
            //   8b55fc               | dec                 eax
            //   52                   | mov                 eax, ebp

        $sequence_10 = { 02c8 41880c18 418a03 240f }
            // n = 4, score = 100
            //   02c8                 | add                 cl, al
            //   41880c18             | inc                 ecx
            //   418a03               | mov                 byte ptr [eax + ebx], cl
            //   240f                 | inc                 ecx

        $sequence_11 = { 8945d8 837dd806 0f8797000000 8b4dd8 ff248d54e94600 8b55f8 }
            // n = 6, score = 100
            //   8945d8               | lea                 ecx, [0x3cb35]
            //   837dd806             | and                 ecx, 0x3f
            //   0f8797000000         | dec                 eax
            //   8b4dd8               | mov                 eax, ebp
            //   ff248d54e94600       | dec                 eax
            //   8b55f8               | sar                 eax, 6

        $sequence_12 = { 83fa78 7f19 0fbe85f3fdffff 0fbe8800ec4900 83e10f 898d28fdffff eb0a }
            // n = 7, score = 100
            //   83fa78               | add                 edi, dword ptr [esp + 0xa8]
            //   7f19                 | dec                 eax
            //   0fbe85f3fdffff       | mov                 ecx, ebp
            //   0fbe8800ec4900       | dec                 esp
            //   83e10f               | lea                 ecx, [0x3cb35]
            //   898d28fdffff         | and                 ecx, 0x3f
            //   eb0a                 | dec                 eax

        $sequence_13 = { 8945f0 817df005010000 7302 eb05 e8???????? 8b4df0 c681f82c4b0000 }
            // n = 7, score = 100
            //   8945f0               | add                 eax, eax
            //   817df005010000       | sub                 ecx, eax
            //   7302                 | je                  0x4f4
            //   eb05                 | lea                 eax, [ecx - 1]
            //   e8????????           |                     
            //   8b4df0               | mov                 eax, dword ptr [edx + eax*4 + 0x6d288]
            //   c681f82c4b0000       | add                 eax, eax

        $sequence_14 = { 03c0 2bc8 0f84ec040000 8d41ff 8b848288d20600 }
            // n = 5, score = 100
            //   03c0                 | add                 eax, dword ptr [esp + 0xc]
            //   2bc8                 | inc                 esp
            //   0f84ec040000         | add                 edx, eax
            //   8d41ff               | dec                 eax
            //   8b848288d20600       | lea                 eax, [0x5561a]

        $sequence_15 = { 0344240c 4403d0 488d051a560500 418b0400 }
            // n = 4, score = 100
            //   0344240c             | inc                 esp
            //   4403d0               | add                 edx, eax
            //   488d051a560500       | inc                 edx
            //   418b0400             | mov                 eax, dword ptr [ebp + eax - 0x19]

    condition:
        7 of them and filesize < 1556480
}