rule win_webc2_adspace_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_adspace."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_adspace"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 8d7c241d c744241400010000 f3ab }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   8d7c241d             | lea                 edi, [esp + 0x1d]
            //   c744241400010000     | mov                 dword ptr [esp + 0x14], 0x100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_1 = { e8???????? 8b4c2420 2bc7 03c1 50 89442424 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   2bc7                 | sub                 eax, edi
            //   03c1                 | add                 eax, ecx
            //   50                   | push                eax
            //   89442424             | mov                 dword ptr [esp + 0x24], eax

        $sequence_2 = { e8???????? 8365fc00 57 56 8d4dec }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   57                   | push                edi
            //   56                   | push                esi
            //   8d4dec               | lea                 ecx, [ebp - 0x14]

        $sequence_3 = { 50 ff15???????? ff742410 e8???????? 56 e8???????? 55 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   55                   | push                ebp

        $sequence_4 = { 50 89442438 e8???????? ff742438 ff15???????? 69c060ea0000 83c42c }
            // n = 7, score = 100
            //   50                   | push                eax
            //   89442438             | mov                 dword ptr [esp + 0x38], eax
            //   e8????????           |                     
            //   ff742438             | push                dword ptr [esp + 0x38]
            //   ff15????????         |                     
            //   69c060ea0000         | imul                eax, eax, 0xea60
            //   83c42c               | add                 esp, 0x2c

        $sequence_5 = { 85c0 7408 c744241001000000 bf???????? }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa
            //   c744241001000000     | mov                 dword ptr [esp + 0x10], 1
            //   bf????????           |                     

        $sequence_6 = { 83c40c 8bf8 8d45fc 50 a1???????? 40 50 }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8bf8                 | mov                 edi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   a1????????           |                     
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_7 = { b8???????? e8???????? 81ec08010000 53 56 8b1d???????? 57 }
            // n = 7, score = 100
            //   b8????????           |                     
            //   e8????????           |                     
            //   81ec08010000         | sub                 esp, 0x108
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b1d????????         |                     
            //   57                   | push                edi

        $sequence_8 = { ffd6 b8???????? 5e 5b c9 }
            // n = 5, score = 100
            //   ffd6                 | call                esi
            //   b8????????           |                     
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_9 = { 83c418 8d85ecfeffff 68???????? 50 ff15???????? 85c0 a3???????? }
            // n = 7, score = 100
            //   83c418               | add                 esp, 0x18
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   a3????????           |                     

    condition:
        7 of them and filesize < 49152
}