rule win_webc2_div_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_div."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_div"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7474 56 6800000080 56 56 }
            // n = 5, score = 100
            //   7474                 | je                  0x76
            //   56                   | push                esi
            //   6800000080           | push                0x80000000
            //   56                   | push                esi
            //   56                   | push                esi

        $sequence_1 = { 8078056e 7512 80780663 750c 80780765 7506 }
            // n = 6, score = 100
            //   8078056e             | cmp                 byte ptr [eax + 5], 0x6e
            //   7512                 | jne                 0x14
            //   80780663             | cmp                 byte ptr [eax + 6], 0x63
            //   750c                 | jne                 0xe
            //   80780765             | cmp                 byte ptr [eax + 7], 0x65
            //   7506                 | jne                 8

        $sequence_2 = { 8d7d02 83c9ff c70001000000 8d5008 33c0 f2ae f7d1 }
            // n = 7, score = 100
            //   8d7d02               | lea                 edi, [ebp + 2]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   c70001000000         | mov                 dword ptr [eax], 1
            //   8d5008               | lea                 edx, [eax + 8]
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx

        $sequence_3 = { c3 55 e8???????? 59 33c0 ebf0 81ec10020000 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   ebf0                 | jmp                 0xfffffff2
            //   81ec10020000         | sub                 esp, 0x210

        $sequence_4 = { 7573 80780661 756d 80780766 }
            // n = 4, score = 100
            //   7573                 | jne                 0x75
            //   80780661             | cmp                 byte ptr [eax + 6], 0x61
            //   756d                 | jne                 0x6f
            //   80780766             | cmp                 byte ptr [eax + 7], 0x66

        $sequence_5 = { 7f09 0fbed0 83ea17 89148e 8d6901 bf16000000 8bc5 }
            // n = 7, score = 100
            //   7f09                 | jg                  0xb
            //   0fbed0               | movsx               edx, al
            //   83ea17               | sub                 edx, 0x17
            //   89148e               | mov                 dword ptr [esi + ecx*4], edx
            //   8d6901               | lea                 ebp, [ecx + 1]
            //   bf16000000           | mov                 edi, 0x16
            //   8bc5                 | mov                 eax, ebp

        $sequence_6 = { 6a20 53 ffd6 59 85c0 }
            // n = 5, score = 100
            //   6a20                 | push                0x20
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_7 = { ff742410 eb14 817c2410808d5b00 771a 8b442414 }
            // n = 5, score = 100
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   eb14                 | jmp                 0x16
            //   817c2410808d5b00     | cmp                 dword ptr [esp + 0x10], 0x5b8d80
            //   771a                 | ja                  0x1c
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]

        $sequence_8 = { 83e803 bf???????? 80240100 83c9ff 33c0 f2ae f7d1 }
            // n = 7, score = 100
            //   83e803               | sub                 eax, 3
            //   bf????????           |                     
            //   80240100             | and                 byte ptr [ecx + eax], 0
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx

        $sequence_9 = { 8b048e 8d1c9510114000 8b17 2bc2 99 }
            // n = 5, score = 100
            //   8b048e               | mov                 eax, dword ptr [esi + ecx*4]
            //   8d1c9510114000       | lea                 ebx, [edx*4 + 0x401110]
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   2bc2                 | sub                 eax, edx
            //   99                   | cdq                 

    condition:
        7 of them and filesize < 32768
}