rule win_webc2_rave_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_rave."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_rave"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8dbc24b0040000 83c9ff f2ae 8b06 8d9424b0040000 f7d1 }
            // n = 6, score = 100
            //   8dbc24b0040000       | lea                 edi, [esp + 0x4b0]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8d9424b0040000       | lea                 edx, [esp + 0x4b0]
            //   f7d1                 | not                 ecx

        $sequence_1 = { 8b742410 8bc6 85f6 89442418 }
            // n = 4, score = 100
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   8bc6                 | mov                 eax, esi
            //   85f6                 | test                esi, esi
            //   89442418             | mov                 dword ptr [esp + 0x18], eax

        $sequence_2 = { f3ab 85db aa 7464 eb06 8b35???????? }
            // n = 6, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   85db                 | test                ebx, ebx
            //   aa                   | stosb               byte ptr es:[edi], al
            //   7464                 | je                  0x66
            //   eb06                 | jmp                 8
            //   8b35????????         |                     

        $sequence_3 = { 83c410 f3ab aa 8d8424a0020000 50 6804010000 }
            // n = 6, score = 100
            //   83c410               | add                 esp, 0x10
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d8424a0020000       | lea                 eax, [esp + 0x2a0]
            //   50                   | push                eax
            //   6804010000           | push                0x104

        $sequence_4 = { c784248800000001010000 66899c248c000000 89842498000000 8984249c000000 ffd7 8b542420 50 }
            // n = 7, score = 100
            //   c784248800000001010000     | mov    dword ptr [esp + 0x88], 0x101
            //   66899c248c000000     | mov                 word ptr [esp + 0x8c], bx
            //   89842498000000       | mov                 dword ptr [esp + 0x98], eax
            //   8984249c000000       | mov                 dword ptr [esp + 0x9c], eax
            //   ffd7                 | call                edi
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]
            //   50                   | push                eax

        $sequence_5 = { 81fb00040000 c644241300 0f87b4000000 b980000000 33c0 8dbc242c010000 }
            // n = 6, score = 100
            //   81fb00040000         | cmp                 ebx, 0x400
            //   c644241300           | mov                 byte ptr [esp + 0x13], 0
            //   0f87b4000000         | ja                  0xba
            //   b980000000           | mov                 ecx, 0x80
            //   33c0                 | xor                 eax, eax
            //   8dbc242c010000       | lea                 edi, [esp + 0x12c]

        $sequence_6 = { 42 56 51 8915???????? }
            // n = 4, score = 100
            //   42                   | inc                 edx
            //   56                   | push                esi
            //   51                   | push                ecx
            //   8915????????         |                     

        $sequence_7 = { 8b8c2410020000 33c0 8bd0 83e20f 40 }
            // n = 5, score = 100
            //   8b8c2410020000       | mov                 ecx, dword ptr [esp + 0x210]
            //   33c0                 | xor                 eax, eax
            //   8bd0                 | mov                 edx, eax
            //   83e20f               | and                 edx, 0xf
            //   40                   | inc                 eax

        $sequence_8 = { aa ffd5 83c410 8d842490000000 8d8c24a8030000 }
            // n = 5, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   ffd5                 | call                ebp
            //   83c410               | add                 esp, 0x10
            //   8d842490000000       | lea                 eax, [esp + 0x90]
            //   8d8c24a8030000       | lea                 ecx, [esp + 0x3a8]

        $sequence_9 = { e8???????? 83c404 85c0 0f848d000000 33c9 33d2 894c2410 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f848d000000         | je                  0x93
            //   33c9                 | xor                 ecx, ecx
            //   33d2                 | xor                 edx, edx
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx

    condition:
        7 of them and filesize < 57344
}