rule win_webc2_table_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_table."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_table"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? b800100000 6a04 50 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   b800100000           | mov                 eax, 0x1000
            //   6a04                 | push                4
            //   50                   | push                eax

        $sequence_1 = { 41 4e 75b7 8b45f8 be???????? 57 56 }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   4e                   | dec                 esi
            //   75b7                 | jne                 0xffffffb9
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   be????????           |                     
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_2 = { e8???????? 85c0 59 7e1b 8b4c2404 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   7e1b                 | jle                 0x1d
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]

        $sequence_3 = { 0f8fdb000000 6860ea0000 ffd7 ff45f4 }
            // n = 4, score = 100
            //   0f8fdb000000         | jg                  0xe1
            //   6860ea0000           | push                0xea60
            //   ffd7                 | call                edi
            //   ff45f4               | inc                 dword ptr [ebp - 0xc]

        $sequence_4 = { c78548fdffff94000000 8d85e8feffff 50 8d85dcfbffff 50 e8???????? 59 }
            // n = 7, score = 100
            //   c78548fdffff94000000     | mov    dword ptr [ebp - 0x2b8], 0x94
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   50                   | push                eax
            //   8d85dcfbffff         | lea                 eax, [ebp - 0x424]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_5 = { e8???????? 8b35???????? 8d8558ffffff 50 ff7508 ffd6 8bf8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b35????????         |                     
            //   8d8558ffffff         | lea                 eax, [ebp - 0xa8]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd6                 | call                esi
            //   8bf8                 | mov                 edi, eax

        $sequence_6 = { 50 8d85e4feffff 50 e8???????? 83c428 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8d85e4feffff         | lea                 eax, [ebp - 0x11c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c428               | add                 esp, 0x28

        $sequence_7 = { 8bca 8dbd59ffffff f3ab 66ab aa 8bca 33c0 }
            // n = 7, score = 100
            //   8bca                 | mov                 ecx, edx
            //   8dbd59ffffff         | lea                 edi, [ebp - 0xa7]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8bca                 | mov                 ecx, edx
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { ff15???????? ff7710 ff15???????? 83c410 50 ff15???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   ff7710               | push                dword ptr [edi + 0x10]
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { e8???????? 83c434 8d8548fdffff c78548fdffff9c000000 50 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c434               | add                 esp, 0x34
            //   8d8548fdffff         | lea                 eax, [ebp - 0x2b8]
            //   c78548fdffff9c000000     | mov    dword ptr [ebp - 0x2b8], 0x9c
            //   50                   | push                eax

    condition:
        7 of them and filesize < 49152
}