rule win_whispergate_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.whispergate."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.whispergate"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 89f4 0f841bffffff 8b5508 85d2 0f8410ffffff 8b5508 }
            // n = 7, score = 300
            //   85c0                 | test                eax, eax
            //   89f4                 | mov                 esp, esi
            //   0f841bffffff         | je                  0xffffff21
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   85d2                 | test                edx, edx
            //   0f8410ffffff         | je                  0xffffff16
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_1 = { 83f801 0f8543010000 83c30c 81fb???????? 0f8389000000 8b13 8b7b04 }
            // n = 7, score = 300
            //   83f801               | cmp                 eax, 1
            //   0f8543010000         | jne                 0x149
            //   83c30c               | add                 ebx, 0xc
            //   81fb????????         |                     
            //   0f8389000000         | jae                 0x8f
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   8b7b04               | mov                 edi, dword ptr [ebx + 4]

        $sequence_2 = { 83c301 ebe1 83c301 ebe3 8d6b01 e9???????? }
            // n = 6, score = 300
            //   83c301               | add                 ebx, 1
            //   ebe1                 | jmp                 0xffffffe3
            //   83c301               | add                 ebx, 1
            //   ebe3                 | jmp                 0xffffffe5
            //   8d6b01               | lea                 ebp, [ebx + 1]
            //   e9????????           |                     

        $sequence_3 = { b8???????? c705????????01000000 2d???????? 83f807 7ee0 57 }
            // n = 6, score = 300
            //   b8????????           |                     
            //   c705????????01000000     |     
            //   2d????????           |                     
            //   83f807               | cmp                 eax, 7
            //   7ee0                 | jle                 0xffffffe2
            //   57                   | push                edi

        $sequence_4 = { 53 83ec4c f605????????02 0f84ea020000 e8???????? 8965c4 }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   83ec4c               | sub                 esp, 0x4c
            //   f605????????02       |                     
            //   0f84ea020000         | je                  0x2f0
            //   e8????????           |                     
            //   8965c4               | mov                 dword ptr [ebp - 0x3c], esp

        $sequence_5 = { 84d2 7906 81cf00ffffff 29f7 8d54241c }
            // n = 5, score = 300
            //   84d2                 | test                dl, dl
            //   7906                 | jns                 8
            //   81cf00ffffff         | or                  edi, 0xffffff00
            //   29f7                 | sub                 edi, esi
            //   8d54241c             | lea                 edx, [esp + 0x1c]

        $sequence_6 = { c1e004 e8???????? 8b4de0 29c4 }
            // n = 4, score = 300
            //   c1e004               | shl                 eax, 4
            //   e8????????           |                     
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   29c4                 | sub                 esp, eax

        $sequence_7 = { 83f802 89c1 7417 8d65f4 89c8 5b }
            // n = 6, score = 300
            //   83f802               | cmp                 eax, 2
            //   89c1                 | mov                 ecx, eax
            //   7417                 | je                  0x19
            //   8d65f4               | lea                 esp, [ebp - 0xc]
            //   89c8                 | mov                 eax, ecx
            //   5b                   | pop                 ebx

        $sequence_8 = { 5e c3 31d2 89d0 c3 }
            // n = 5, score = 300
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   31d2                 | xor                 edx, edx
            //   89d0                 | mov                 eax, edx
            //   c3                   | ret                 

        $sequence_9 = { c706???????? 893424 8b4d10 89fa 89d8 e8???????? }
            // n = 6, score = 300
            //   c706????????         |                     
            //   893424               | mov                 dword ptr [esp], esi
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   89fa                 | mov                 edx, edi
            //   89d8                 | mov                 eax, ebx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 114688
}