rule win_whitebird_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.whitebird."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.whitebird"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb09 80f92f 0f95c1 80c13f }
            // n = 4, score = 400
            //   eb09                 | jmp                 0xb
            //   80f92f               | cmp                 cl, 0x2f
            //   0f95c1               | setne               cl
            //   80c13f               | add                 cl, 0x3f

        $sequence_1 = { 488b83e8140000 488d15a7f2ffff 41b82f000000 488901 488b83f0140000 }
            // n = 5, score = 200
            //   488b83e8140000       | mov                 dword ptr [esi], ebx
            //   488d15a7f2ffff       | dec                 esp
            //   41b82f000000         | lea                 ecx, [esp + 0x40]
            //   488901               | inc                 ebp
            //   488b83f0140000       | mov                 eax, esp

        $sequence_2 = { 56 e8???????? 59 8945d4 85c0 0f84f5000000 6a00 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   85c0                 | test                eax, eax
            //   0f84f5000000         | je                  0xfb
            //   6a00                 | push                0

        $sequence_3 = { 66898d56ffffff 59 6689855cffffff 66898d58ffffff 8bc8 33c0 }
            // n = 6, score = 200
            //   66898d56ffffff       | mov                 word ptr [ebp - 0xaa], cx
            //   59                   | pop                 ecx
            //   6689855cffffff       | mov                 word ptr [ebp - 0xa4], ax
            //   66898d58ffffff       | mov                 word ptr [ebp - 0xa8], cx
            //   8bc8                 | mov                 ecx, eax
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 74ea 3918 7467 8b85f4feffff }
            // n = 4, score = 200
            //   74ea                 | je                  0xffffffec
            //   3918                 | cmp                 dword ptr [eax], ebx
            //   7467                 | je                  0x69
            //   8b85f4feffff         | mov                 eax, dword ptr [ebp - 0x10c]

        $sequence_5 = { 7cd5 41c60300 4863c2 4c2bd8 4c891e }
            // n = 5, score = 200
            //   7cd5                 | mov                 eax, dword ptr [esp + 0x58]
            //   41c60300             | jl                  0xffffffd7
            //   4863c2               | inc                 ecx
            //   4c2bd8               | mov                 byte ptr [ebx], 0
            //   4c891e               | dec                 eax

        $sequence_6 = { 4c8d4c2440 458bc4 488bd0 488bcd }
            // n = 4, score = 200
            //   4c8d4c2440           | arpl                dx, ax
            //   458bc4               | dec                 esp
            //   488bd0               | sub                 ebx, eax
            //   488bcd               | dec                 esp

        $sequence_7 = { 66898572ffffff 66898d68ffffff 59 6a73 66898d6affffff 8bc8 58 }
            // n = 7, score = 200
            //   66898572ffffff       | mov                 word ptr [ebp - 0x8e], ax
            //   66898d68ffffff       | mov                 word ptr [ebp - 0x98], cx
            //   59                   | pop                 ecx
            //   6a73                 | push                0x73
            //   66898d6affffff       | mov                 word ptr [ebp - 0x96], cx
            //   8bc8                 | mov                 ecx, eax
            //   58                   | pop                 eax

        $sequence_8 = { 488d0dacc9ffff 41b808020000 ff15???????? 4c8d5c2478 488d8424b0000000 }
            // n = 5, score = 200
            //   488d0dacc9ffff       | dec                 eax
            //   41b808020000         | mov                 edx, eax
            //   ff15????????         |                     
            //   4c8d5c2478           | dec                 eax
            //   488d8424b0000000     | mov                 ecx, ebp

        $sequence_9 = { 8d43f5 66898c2400010000 66898424fe000000 8d43f6 6689942408010000 }
            // n = 5, score = 200
            //   8d43f5               | lea                 eax, [ebx - 0xb]
            //   66898c2400010000     | mov                 word ptr [esp + 0x100], cx
            //   66898424fe000000     | mov                 word ptr [esp + 0xfe], ax
            //   8d43f6               | lea                 eax, [ebx - 0xa]
            //   6689942408010000     | mov                 word ptr [esp + 0x108], dx

        $sequence_10 = { ffd0 8d4584 50 6802000080 }
            // n = 4, score = 200
            //   ffd0                 | call                eax
            //   8d4584               | lea                 eax, [ebp - 0x7c]
            //   50                   | push                eax
            //   6802000080           | push                0x80000002

        $sequence_11 = { 41bc00200000 498bd4 488d8c2450050000 e8???????? 33c0 488bcb }
            // n = 6, score = 200
            //   41bc00200000         | dec                 eax
            //   498bd4               | mov                 eax, dword ptr [ebx + 0x14e8]
            //   488d8c2450050000     | dec                 eax
            //   e8????????           |                     
            //   33c0                 | lea                 edx, [0xfffff2a7]
            //   488bcb               | inc                 ecx

        $sequence_12 = { 8985b8fcffff 8b859cfcffff 0fb74002 83c40c 50 c785b4fcffff06000000 ff15???????? }
            // n = 7, score = 200
            //   8985b8fcffff         | mov                 dword ptr [ebp - 0x348], eax
            //   8b859cfcffff         | mov                 eax, dword ptr [ebp - 0x364]
            //   0fb74002             | movzx               eax, word ptr [eax + 2]
            //   83c40c               | add                 esp, 0xc
            //   50                   | push                eax
            //   c785b4fcffff06000000     | mov    dword ptr [ebp - 0x34c], 6
            //   ff15????????         |                     

        $sequence_13 = { 83fe1a 0f8c77ffffff 488d4c2450 ff15???????? 8b542460 8b442458 }
            // n = 6, score = 200
            //   83fe1a               | cmp                 esi, 0x1a
            //   0f8c77ffffff         | jl                  0xffffff7d
            //   488d4c2450           | dec                 eax
            //   ff15????????         |                     
            //   8b542460             | lea                 ecx, [esp + 0x50]
            //   8b442458             | mov                 edx, dword ptr [esp + 0x60]

        $sequence_14 = { 6806020000 50 668985f4fdffff 8d85f6fdffff 50 e8???????? 8bc7 }
            // n = 7, score = 200
            //   6806020000           | push                0x206
            //   50                   | push                eax
            //   668985f4fdffff       | mov                 word ptr [ebp - 0x20c], ax
            //   8d85f6fdffff         | lea                 eax, [ebp - 0x20a]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi

    condition:
        7 of them and filesize < 139264
}