rule win_wininetloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wininetloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wininetloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66490f7ed9 4c8d050cb70500 ba28000000 488d4ddf e8???????? 4863d8 498b4540 }
            // n = 7, score = 100
            //   66490f7ed9           | dec                 eax
            //   4c8d050cb70500       | mov                 eax, dword ptr [ebp - 9]
            //   ba28000000           | dec                 eax
            //   488d4ddf             | mov                 dword ptr [ebx + 0x20], eax
            //   e8????????           |                     
            //   4863d8               | dec                 eax
            //   498b4540             | mov                 dword ptr [ebx + 0x28], eax

        $sequence_1 = { c3 488b0d???????? ba51230000 ff15???????? 488b0d???????? ba53230000 4889442430 }
            // n = 7, score = 100
            //   c3                   | dec                 eax
            //   488b0d????????       |                     
            //   ba51230000           | mov                 eax, edx
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   ba53230000           | dec                 eax
            //   4889442430           | sub                 eax, ecx

        $sequence_2 = { 5b c3 803d????????00 0f8459ffffff 498bd1 488bcb 4883c430 }
            // n = 7, score = 100
            //   5b                   | inc                 esp
            //   c3                   | mov                 dword ptr [eax + 8], edi
            //   803d????????00       |                     
            //   0f8459ffffff         | dec                 eax
            //   498bd1               | lea                 eax, [0x61d46]
            //   488bcb               | dec                 eax
            //   4883c430             | mov                 dword ptr [edi], eax

        $sequence_3 = { 458d4118 488bce ff15???????? 8b442430 4038bc24e0000000 0f45442434 4c63c0 }
            // n = 7, score = 100
            //   458d4118             | mov                 edx, esi
            //   488bce               | dec                 eax
            //   ff15????????         |                     
            //   8b442430             | lea                 ecx, [ebp - 9]
            //   4038bc24e0000000     | nop                 
            //   0f45442434           | dec                 esp
            //   4c63c0               | lea                 ecx, [0xcc78b]

        $sequence_4 = { 48891d???????? 48c705????????0f000000 881d???????? 448d431b 488d15d9be0f00 488d0d522e1200 e8???????? }
            // n = 7, score = 100
            //   48891d????????       |                     
            //   48c705????????0f000000     |     
            //   881d????????         |                     
            //   448d431b             | dec                 eax
            //   488d15d9be0f00       | lea                 ecx, [edx + 0x60]
            //   488d0d522e1200       | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { eb02 b301 4883fa10 722d 48ffc2 488bc1 4881fa00100000 }
            // n = 7, score = 100
            //   eb02                 | jmp                 0x8fc
            //   b301                 | dec                 eax
            //   4883fa10             | lea                 eax, [0x542b9]
            //   722d                 | xorps               xmm0, xmm0
            //   48ffc2               | movups              xmmword ptr [ecx + 8], xmm0
            //   488bc1               | dec                 eax
            //   4881fa00100000       | mov                 dword ptr [ecx], eax

        $sequence_6 = { c6430600 eb21 48c744242006000000 4c8d0dc3d10b00 4533c0 418d5006 488d4c2430 }
            // n = 7, score = 100
            //   c6430600             | dec                 eax
            //   eb21                 | mov                 dword ptr [eax - 8], ecx
            //   48c744242006000000     | jmp    0x4be
            //   4c8d0dc3d10b00       | dec                 eax
            //   4533c0               | mov                 ecx, eax
            //   418d5006             | dec                 eax
            //   488d4c2430           | test                eax, eax

        $sequence_7 = { 803a5c 752a 4c8d4201 4c3bc0 7421 f6c108 750a }
            // n = 7, score = 100
            //   803a5c               | dec                 eax
            //   752a                 | mov                 dword ptr [esp + 0x30], eax
            //   4c8d4201             | dec                 eax
            //   4c3bc0               | lea                 eax, [0xb7924]
            //   7421                 | inc                 ebp
            //   f6c108               | xor                 eax, eax
            //   750a                 | mov                 edx, 0x251c

        $sequence_8 = { e9???????? 488d8aa8000000 4883c108 e9???????? 488d8aa8000000 e9???????? 4055 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d8aa8000000       | dec                 eax
            //   4883c108             | mov                 dword ptr [esp + 0x28], eax
            //   e9????????           |                     
            //   488d8aa8000000       | mov                 dword ptr [esp + 0x20], 0x3c
            //   e9????????           |                     
            //   4055                 | dec                 eax

        $sequence_9 = { 5e 5d c3 ba5e230000 488b4e18 ff15???????? 488bc8 }
            // n = 7, score = 100
            //   5e                   | test                eax, eax
            //   5d                   | jne                 0x256
            //   c3                   | jae                 0x24e
            //   ba5e230000           | dec                 eax
            //   488b4e18             | lea                 ecx, [0x9468e]
            //   ff15????????         |                     
            //   488bc8               | dec                 esp

    condition:
        7 of them and filesize < 2659328
}