rule win_winnti_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.winnti."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.winnti"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 56 ff15???????? 85c0 7e79 8d4c2418 8d942484000000 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7e79                 | jle                 0x7b
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   8d942484000000       | lea                 edx, [esp + 0x84]

        $sequence_1 = { 8dbc24c4000000 8d942410010000 f3ab 668b8424740b0000 bf???????? 66898424d2050000 83c9ff }
            // n = 7, score = 200
            //   8dbc24c4000000       | lea                 edi, [esp + 0xc4]
            //   8d942410010000       | lea                 edx, [esp + 0x110]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   668b8424740b0000     | mov                 ax, word ptr [esp + 0xb74]
            //   bf????????           |                     
            //   66898424d2050000     | mov                 word ptr [esp + 0x5d2], ax
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_2 = { 8b734c 03f8 8bc1 c1e902 f3a5 8bc8 }
            // n = 6, score = 200
            //   8b734c               | mov                 esi, dword ptr [ebx + 0x4c]
            //   03f8                 | add                 edi, eax
            //   8bc1                 | mov                 eax, ecx
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax

        $sequence_3 = { f3ab 8b8c2498010000 c644242004 51 c644242501 ff15???????? }
            // n = 6, score = 200
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b8c2498010000       | mov                 ecx, dword ptr [esp + 0x198]
            //   c644242004           | mov                 byte ptr [esp + 0x20], 4
            //   51                   | push                ecx
            //   c644242501           | mov                 byte ptr [esp + 0x25], 1
            //   ff15????????         |                     

        $sequence_4 = { ffd7 68???????? 68???????? 89460c }
            // n = 4, score = 200
            //   ffd7                 | call                edi
            //   68????????           |                     
            //   68????????           |                     
            //   89460c               | mov                 dword ptr [esi + 0xc], eax

        $sequence_5 = { 85c0 751a 8bcb 8d142e 2bce 51 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   751a                 | jne                 0x1c
            //   8bcb                 | mov                 ecx, ebx
            //   8d142e               | lea                 edx, [esi + ebp]
            //   2bce                 | sub                 ecx, esi
            //   51                   | push                ecx

        $sequence_6 = { e8???????? 8b4c2418 50 6800040000 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   50                   | push                eax
            //   6800040000           | push                0x400

        $sequence_7 = { 8bfa 83c9ff f2ae 8b54242c }
            // n = 4, score = 200
            //   8bfa                 | mov                 edi, edx
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8b54242c             | mov                 edx, dword ptr [esp + 0x2c]

        $sequence_8 = { 0f849a000000 4c8d5b2e 660f1f440000 410fb70b 458bca }
            // n = 5, score = 100
            //   0f849a000000         | je                  0x21
            //   4c8d5b2e             | inc                 ecx
            //   660f1f440000         | cmp                 esi, 1
            //   410fb70b             | jne                 0x15
            //   458bca               | je                  0xa0

        $sequence_9 = { 8b4b1c 4803cf 8b0491 4803c7 488b5c2410 }
            // n = 5, score = 100
            //   8b4b1c               | dec                 eax
            //   4803cf               | lea                 edx, [esp + 0x50]
            //   8b0491               | inc                 eax
            //   4803c7               | cmp                 byte ptr [esp + 0x50], dh
            //   488b5c2410           | inc                 eax

        $sequence_10 = { 4585d2 759d 488b7db7 458bd9 44894d97 }
            // n = 5, score = 100
            //   4585d2               | add                 ecx, edi
            //   759d                 | mov                 eax, dword ptr [ecx + edx*4]
            //   488b7db7             | dec                 eax
            //   458bd9               | add                 eax, edi
            //   44894d97             | dec                 eax

        $sequence_11 = { 4053 4883ec40 48c74424580a000000 488b442458 4c8d442458 }
            // n = 5, score = 100
            //   4053                 | xor                 eax, eax
            //   4883ec40             | dec                 eax
            //   48c74424580a000000     | add    esp, 0xe0
            //   488b442458           | inc                 ecx
            //   4c8d442458           | pop                 edi

        $sequence_12 = { 4863c9 e8???????? 488bd8 4c8d443710 4983781810 7203 4d8b00 }
            // n = 7, score = 100
            //   4863c9               | sub                 eax, edx
            //   e8????????           |                     
            //   488bd8               | dec                 eax
            //   4c8d443710           | mov                 dword ptr [esp + 0x88], 0
            //   4983781810           | dec                 eax
            //   7203                 | lea                 edx, [esp + 0x88]
            //   4d8b00               | dec                 eax

        $sequence_13 = { 75f1 408830 488d542450 4038742450 }
            // n = 4, score = 100
            //   75f1                 | js                  0x4c
            //   408830               | dec                 eax
            //   488d542450           | mov                 ecx, dword ptr [esp + 0xb0]
            //   4038742450           | jne                 0x13

        $sequence_14 = { 90 488bd0 488d4b28 e8???????? 90 48837dd710 7209 }
            // n = 7, score = 100
            //   90                   | pop                 esi
            //   488bd0               | or                  eax, 0xffffffff
            //   488d4b28             | pop                 ebp
            //   e8????????           |                     
            //   90                   | add                 esp, 8
            //   48837dd710           | ret                 
            //   7209                 | cdq                 

        $sequence_15 = { 4863d9 4c8be3 49c1fc05 4c8d355a4f0a00 83e31f 486bdb58 }
            // n = 6, score = 100
            //   4863d9               | lea                 edx, [0x1d853]
            //   4c8be3               | inc                 ebp
            //   49c1fc05             | test                edx, edx
            //   4c8d355a4f0a00       | jne                 0xffffffa2
            //   83e31f               | dec                 eax
            //   486bdb58             | mov                 edi, dword ptr [ebp - 0x49]

        $sequence_16 = { 48c784248800000000000000 488d942488000000 488d4c2428 e8???????? 488d05e7700100 4889442428 488d1553d80100 }
            // n = 7, score = 100
            //   48c784248800000000000000     | dec    eax
            //   488d942488000000     | lea                 edx, [ebp + 0x68]
            //   488d4c2428           | dec                 eax
            //   e8????????           |                     
            //   488d05e7700100       | mov                 ecx, dword ptr [ebp + 0x100]
            //   4889442428           | mov                 ecx, dword ptr [ebx + 0x1c]
            //   488d1553d80100       | dec                 eax

        $sequence_17 = { 7517 488d0513ac0a00 488b4c2430 483bc8 7406 e8???????? 90 }
            // n = 7, score = 100
            //   7517                 | mov                 ebx, dword ptr [esp + 0x10]
            //   488d0513ac0a00       | inc                 ecx
            //   488b4c2430           | push                edi
            //   483bc8               | dec                 eax
            //   7406                 | sub                 esp, 0xd0
            //   e8????????           |                     
            //   90                   | inc                 ebp

        $sequence_18 = { 7511 33c0 4881c4e0000000 415f 415e }
            // n = 5, score = 100
            //   7511                 | movzx               ecx, word ptr [ebx]
            //   33c0                 | inc                 ebp
            //   4881c4e0000000       | mov                 ecx, edx
            //   415f                 | mov                 ebx, eax
            //   415e                 | test                eax, eax

        $sequence_19 = { 4889742430 488b442440 48894310 48894b18 48897c2448 }
            // n = 5, score = 100
            //   4889742430           | xor                 esi, esi
            //   488b442440           | inc                 esp
            //   48894310             | mov                 dword ptr [esp + 0x60], esi
            //   48894b18             | dec                 esp
            //   48897c2448           | mov                 dword ptr [eax + 0x18], esi

        $sequence_20 = { 741e 837d6001 7511 488d5568 ff15???????? 488b8d00010000 ff15???????? }
            // n = 7, score = 100
            //   741e                 | inc                 ecx
            //   837d6001             | pop                 esi
            //   7511                 | jne                 0xfffffff3
            //   488d5568             | inc                 eax
            //   ff15????????         |                     
            //   488b8d00010000       | mov                 byte ptr [eax], dh
            //   ff15????????         |                     

        $sequence_21 = { 48897c2478 488b8c2400010000 4885c9 741f 4183fe01 7513 }
            // n = 6, score = 100
            //   48897c2478           | dec                 eax
            //   488b8c2400010000     | mov                 dword ptr [esp + 0x78], edi
            //   4885c9               | dec                 eax
            //   741f                 | mov                 ecx, dword ptr [esp + 0x100]
            //   4183fe01             | dec                 eax
            //   7513                 | test                ecx, ecx

        $sequence_22 = { 8bd8 85c0 7848 488b8c24b0000000 }
            // n = 4, score = 100
            //   8bd8                 | dec                 esp
            //   85c0                 | lea                 ebx, [ebx + 0x2e]
            //   7848                 | nop                 word ptr [eax + eax]
            //   488b8c24b0000000     | inc                 ecx

        $sequence_23 = { 488d0527eb0a00 eb04 4883c010 4883c428 c3 4883ec28 e8???????? }
            // n = 7, score = 100
            //   488d0527eb0a00       | lea                 ecx, [esp + 0x28]
            //   eb04                 | dec                 eax
            //   4883c010             | lea                 eax, [0x170e7]
            //   4883c428             | dec                 eax
            //   c3                   | mov                 dword ptr [esp + 0x28], eax
            //   4883ec28             | dec                 eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1581056
}