rule win_winordll64_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.winordll64."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.winordll64"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b55d0 488364242000 448bc1 4c8d4d48 498bcc ff15???????? 48635538 }
            // n = 7, score = 100
            //   488b55d0             | dec                 ecx
            //   488364242000         | mov                 eax, eax
            //   448bc1               | dec                 eax
            //   4c8d4d48             | shr                 eax, 0x3f
            //   498bcc               | dec                 eax
            //   ff15????????         |                     
            //   48635538             | sub                 eax, ecx

        $sequence_1 = { 4c8d05c8c40000 498bd4 488bcd e8???????? 85c0 }
            // n = 5, score = 100
            //   4c8d05c8c40000       | mov                 eax, ebp
            //   498bd4               | imul                eax, eax, 0xe
            //   488bcd               | dec                 ecx
            //   e8????????           |                     
            //   85c0                 | mov                 eax, esi

        $sequence_2 = { 75f7 488bcf e8???????? 498b0c24 4585ed }
            // n = 5, score = 100
            //   75f7                 | jmp                 0x40b
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   498b0c24             | add                 edx, 8
            //   4585ed               | jne                 0x402

        $sequence_3 = { 488bcf ff15???????? 85c0 0f8575ffffff 488bcf ff15???????? b8c0020000 }
            // n = 7, score = 100
            //   488bcf               | cmovae              ebx, dword ptr [ebp - 0x60]
            //   ff15????????         |                     
            //   85c0                 | mov                 ecx, edi
            //   0f8575ffffff         | dec                 ebp
            //   488bcf               | test                ebx, ebx
            //   ff15????????         |                     
            //   b8c0020000           | dec                 eax

        $sequence_4 = { e8???????? 4c8d5c2430 4c895c2420 4c8d4c2438 41b807000000 488b442440 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   4c8d5c2430           | dec                 eax
            //   4c895c2420           | lea                 eax, [esp + 0x48]
            //   4c8d4c2438           | dec                 eax
            //   41b807000000         | mov                 dword ptr [esp + 0x20], eax
            //   488b442440           | mov                 edx, 0x12

        $sequence_5 = { be08780000 8bce e8???????? 488bf8 4885c0 0f8422010000 48ffce }
            // n = 7, score = 100
            //   be08780000           | dec                 eax
            //   8bce                 | inc                 ecx
            //   e8????????           |                     
            //   488bf8               | dec                 eax
            //   4885c0               | cmp                 ecx, edx
            //   0f8422010000         | jb                  0x3ae
            //   48ffce               | mov                 edx, 0x11

        $sequence_6 = { 488d5547 488d4def 4c895d47 e8???????? 4c8d1d9b4a0000 488d150c640000 488d4def }
            // n = 7, score = 100
            //   488d5547             | lea                 eax, [ebp - 4]
            //   488d4def             | inc                 ecx
            //   4c895d47             | dec                 eax
            //   e8????????           |                     
            //   4c8d1d9b4a0000       | add                 eax, 2
            //   488d150c640000       | cmp                 word ptr [eax], dx
            //   488d4def             | jne                 0x1a1

        $sequence_7 = { 48ffc1 483bca 72f0 458bc7 }
            // n = 4, score = 100
            //   48ffc1               | mov                 ebp, edx
            //   483bca               | dec                 ecx
            //   72f0                 | sar                 ebp, 3
            //   458bc7               | dec                 ecx

        $sequence_8 = { 418800 49ffc0 49ffc3 41d1ea 418b03 488b6c2450 be00000080 }
            // n = 7, score = 100
            //   418800               | inc                 ecx
            //   49ffc0               | lea                 edi, [esp - 0x19]
            //   49ffc3               | jne                 0x5b2
            //   41d1ea               | inc                 ecx
            //   418b03               | mov                 eax, esi
            //   488b6c2450           | inc                 eax
            //   be00000080           | dec                 eax

        $sequence_9 = { 488d542458 488d4c2428 e8???????? 4c8d1d12e50000 4c895c2428 }
            // n = 5, score = 100
            //   488d542458           | dec                 eax
            //   488d4c2428           | dec                 eax
            //   e8????????           |                     
            //   4c8d1d12e50000       | jne                 0x289
            //   4c895c2428           | dec                 eax

    condition:
        7 of them and filesize < 278528
}