rule win_winos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.winos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.winos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66890c70 5e 8bc7 5f 5b 5d c20800 }
            // n = 7, score = 100
            //   66890c70             | mov                 word ptr [eax + esi*2], cx
            //   5e                   | pop                 esi
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8

        $sequence_1 = { eb0d 8d95bcfbffff 52 ff15???????? 8b85bcfbffff b906000000 663bc8 }
            // n = 7, score = 100
            //   eb0d                 | jmp                 0xf
            //   8d95bcfbffff         | lea                 edx, [ebp - 0x444]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b85bcfbffff         | mov                 eax, dword ptr [ebp - 0x444]
            //   b906000000           | mov                 ecx, 6
            //   663bc8               | cmp                 cx, ax

        $sequence_2 = { 8d8de0fcffff 57 51 e8???????? 8b1d???????? }
            // n = 5, score = 100
            //   8d8de0fcffff         | lea                 ecx, [ebp - 0x320]
            //   57                   | push                edi
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b1d????????         |                     

        $sequence_3 = { 83c40c 899c2460040000 33db 8d4c243c 51 89bc246c040000 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   899c2460040000       | mov                 dword ptr [esp + 0x460], ebx
            //   33db                 | xor                 ebx, ebx
            //   8d4c243c             | lea                 ecx, [esp + 0x3c]
            //   51                   | push                ecx
            //   89bc246c040000       | mov                 dword ptr [esp + 0x46c], edi

        $sequence_4 = { 2bd6 c1fa02 899530feffff 3bdf 7563 8bc3 }
            // n = 6, score = 100
            //   2bd6                 | sub                 edx, esi
            //   c1fa02               | sar                 edx, 2
            //   899530feffff         | mov                 dword ptr [ebp - 0x1d0], edx
            //   3bdf                 | cmp                 ebx, edi
            //   7563                 | jne                 0x65
            //   8bc3                 | mov                 eax, ebx

        $sequence_5 = { 8d4db8 50 8b853cffffff 50 }
            // n = 4, score = 100
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   50                   | push                eax
            //   8b853cffffff         | mov                 eax, dword ptr [ebp - 0xc4]
            //   50                   | push                eax

        $sequence_6 = { 8b442418 53 52 6a03 6a00 56 }
            // n = 6, score = 100
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   53                   | push                ebx
            //   52                   | push                edx
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_7 = { c70009000000 e8???????? ebda 8bc3 c1f805 8d3c8540310310 8bf3 }
            // n = 7, score = 100
            //   c70009000000         | mov                 dword ptr [eax], 9
            //   e8????????           |                     
            //   ebda                 | jmp                 0xffffffdc
            //   8bc3                 | mov                 eax, ebx
            //   c1f805               | sar                 eax, 5
            //   8d3c8540310310       | lea                 edi, [eax*4 + 0x10033140]
            //   8bf3                 | mov                 esi, ebx

        $sequence_8 = { 5d c3 55 8bec 8b4e10 }
            // n = 5, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]

        $sequence_9 = { db45cc d84dc8 e8???????? 8b7dbc 8bf0 8945c4 6a4c }
            // n = 7, score = 100
            //   db45cc               | fild                dword ptr [ebp - 0x34]
            //   d84dc8               | fmul                dword ptr [ebp - 0x38]
            //   e8????????           |                     
            //   8b7dbc               | mov                 edi, dword ptr [ebp - 0x44]
            //   8bf0                 | mov                 esi, eax
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   6a4c                 | push                0x4c

    condition:
        7 of them and filesize < 457728
}