rule win_wipbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wipbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wipbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 89cb 48 89d6 b98855514f ba4656f1f6 e8???????? }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   89cb                 | mov                 ebx, ecx
            //   48                   | dec                 eax
            //   89d6                 | mov                 esi, edx
            //   b98855514f           | mov                 ecx, 0x4f515588
            //   ba4656f1f6           | mov                 edx, 0xf6f15646
            //   e8????????           |                     

        $sequence_1 = { c744241400000000 c744241800000000 8974240c 89542410 c74424080a000000 890424 }
            // n = 6, score = 100
            //   c744241400000000     | mov                 dword ptr [esp + 0x14], 0
            //   c744241800000000     | mov                 dword ptr [esp + 0x18], 0
            //   8974240c             | mov                 dword ptr [esp + 0xc], esi
            //   89542410             | mov                 dword ptr [esp + 0x10], edx
            //   c74424080a000000     | mov                 dword ptr [esp + 8], 0xa
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_2 = { 48 01cb 66813b9090 0f8404040000 bace2cfb69 b98855514f }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   01cb                 | add                 ebx, ecx
            //   66813b9090           | cmp                 word ptr [ebx], 0x9090
            //   0f8404040000         | je                  0x40a
            //   bace2cfb69           | mov                 edx, 0x69fb2cce
            //   b98855514f           | mov                 ecx, 0x4f515588

        $sequence_3 = { 85c0 48 8907 74a0 48 83c708 48 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   48                   | dec                 eax
            //   8907                 | mov                 dword ptr [edi], eax
            //   74a0                 | je                  0xffffffa2
            //   48                   | dec                 eax
            //   83c708               | add                 edi, 8
            //   48                   | dec                 eax

        $sequence_4 = { c744240400000000 893424 89442408 ffd7 }
            // n = 4, score = 100
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   893424               | mov                 dword ptr [esp], esi
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   ffd7                 | call                edi

        $sequence_5 = { ba2e9fd298 b98855514f e8???????? 49 }
            // n = 4, score = 100
            //   ba2e9fd298           | mov                 edx, 0x98d29f2e
            //   b98855514f           | mov                 ecx, 0x4f515588
            //   e8????????           |                     
            //   49                   | dec                 ecx

        $sequence_6 = { 89e5 e8???????? 85c0 7405 8b4034 eb02 }
            // n = 6, score = 100
            //   89e5                 | mov                 ebp, esp
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   8b4034               | mov                 eax, dword ptr [eax + 0x34]
            //   eb02                 | jmp                 4

        $sequence_7 = { 41 b901000000 ba01000000 4c 8d442468 48 8d4c246c }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   b901000000           | mov                 ecx, 1
            //   ba01000000           | mov                 edx, 1
            //   4c                   | dec                 esp
            //   8d442468             | lea                 eax, [esp + 0x68]
            //   48                   | dec                 eax
            //   8d4c246c             | lea                 ecx, [esp + 0x6c]

        $sequence_8 = { 740d 8b45f4 e8???????? e9???????? 89d8 e8???????? 85c0 }
            // n = 7, score = 100
            //   740d                 | je                  0xf
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   e9????????           |                     
            //   89d8                 | mov                 eax, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_9 = { 48 8b442428 eb02 31c0 48 }
            // n = 5, score = 100
            //   48                   | dec                 eax
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   eb02                 | jmp                 4
            //   31c0                 | xor                 eax, eax
            //   48                   | dec                 eax

    condition:
        7 of them and filesize < 253952
}