rule win_wm_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wm_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wm_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89481c 894820 894824 6a00 b901000000 6a00 6689480c }
            // n = 7, score = 100
            //   89481c               | mov                 dword ptr [eax + 0x1c], ecx
            //   894820               | mov                 dword ptr [eax + 0x20], ecx
            //   894824               | mov                 dword ptr [eax + 0x24], ecx
            //   6a00                 | push                0
            //   b901000000           | mov                 ecx, 1
            //   6a00                 | push                0
            //   6689480c             | mov                 word ptr [eax + 0xc], cx

        $sequence_1 = { 8d8c24e4110000 ff15???????? c684247c31020056 8b8424d4110000 8b4804 f6840cdc11000006 0f842c010000 }
            // n = 7, score = 100
            //   8d8c24e4110000       | lea                 ecx, [esp + 0x11e4]
            //   ff15????????         |                     
            //   c684247c31020056     | mov                 byte ptr [esp + 0x2317c], 0x56
            //   8b8424d4110000       | mov                 eax, dword ptr [esp + 0x11d4]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   f6840cdc11000006     | test                byte ptr [esp + ecx + 0x11dc], 6
            //   0f842c010000         | je                  0x132

        $sequence_2 = { 83f8ff 0f8423070000 90 f684247402000010 0f8492020000 68fc070000 8d8c24f80b0000 }
            // n = 7, score = 100
            //   83f8ff               | cmp                 eax, -1
            //   0f8423070000         | je                  0x729
            //   90                   | nop                 
            //   f684247402000010     | test                byte ptr [esp + 0x274], 0x10
            //   0f8492020000         | je                  0x298
            //   68fc070000           | push                0x7fc
            //   8d8c24f80b0000       | lea                 ecx, [esp + 0xbf8]

        $sequence_3 = { ff15???????? 33c9 6a30 51 8d9424aa100000 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   33c9                 | xor                 ecx, ecx
            //   6a30                 | push                0x30
            //   51                   | push                ecx
            //   8d9424aa100000       | lea                 edx, [esp + 0x10aa]

        $sequence_4 = { 8b4c240c 6aff 8d542414 894608 }
            // n = 4, score = 100
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   6aff                 | push                -1
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   894608               | mov                 dword ptr [esi + 8], eax

        $sequence_5 = { 83c404 6a64 ffd6 8b4c2414 51 e8???????? 83c404 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   6a64                 | push                0x64
            //   ffd6                 | call                esi
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_6 = { b804000000 2bc6 50 8d0c3e 51 52 }
            // n = 6, score = 100
            //   b804000000           | mov                 eax, 4
            //   2bc6                 | sub                 eax, esi
            //   50                   | push                eax
            //   8d0c3e               | lea                 ecx, [esi + edi]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_7 = { 50 8b4204 ffd0 c684245402000000 8b44241c 83c0f0 8d480c }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   ffd0                 | call                eax
            //   c684245402000000     | mov                 byte ptr [esp + 0x254], 0
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   83c0f0               | add                 eax, -0x10
            //   8d480c               | lea                 ecx, [eax + 0xc]

        $sequence_8 = { 84c0 0f84f4e9ffff 83ec1c 8bcc 89642434 68???????? ff15???????? }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   0f84f4e9ffff         | je                  0xffffe9fa
            //   83ec1c               | sub                 esp, 0x1c
            //   8bcc                 | mov                 ecx, esp
            //   89642434             | mov                 dword ptr [esp + 0x34], esp
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_9 = { 3b01 743b 8b542428 8b4e14 2bd0 8d4c0a01 51 }
            // n = 7, score = 100
            //   3b01                 | cmp                 eax, dword ptr [ecx]
            //   743b                 | je                  0x3d
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   2bd0                 | sub                 edx, eax
            //   8d4c0a01             | lea                 ecx, [edx + ecx + 1]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 258048
}