rule win_wmighost_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wmighost."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wmighost"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff5238 8945fc 837dfc00 7d12 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff5238               | call                dword ptr [edx + 0x38]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7d12                 | jge                 0x14

        $sequence_1 = { 8b95f8feffff 52 ff15???????? 83c410 8b85f8feffff 50 }
            // n = 6, score = 100
            //   8b95f8feffff         | mov                 edx, dword ptr [ebp - 0x108]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   8b85f8feffff         | mov                 eax, dword ptr [ebp - 0x108]
            //   50                   | push                eax

        $sequence_2 = { 8d95f0fcffff 52 ff15???????? 68e8030000 ff15???????? }
            // n = 5, score = 100
            //   8d95f0fcffff         | lea                 edx, [ebp - 0x310]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   68e8030000           | push                0x3e8
            //   ff15????????         |                     

        $sequence_3 = { c745fcffffffff 8d4de8 e8???????? e9???????? 51 8bcc 8965c4 }
            // n = 7, score = 100
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e8????????           |                     
            //   e9????????           |                     
            //   51                   | push                ecx
            //   8bcc                 | mov                 ecx, esp
            //   8965c4               | mov                 dword ptr [ebp - 0x3c], esp

        $sequence_4 = { 8bc8 e8???????? 6aff 8d4de8 e8???????? }
            // n = 5, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   6aff                 | push                -1
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e8????????           |                     

        $sequence_5 = { 50 64892500000000 83ec08 894dec c745fc00000000 8d4d08 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   64892500000000       | mov                 dword ptr fs:[0], esp
            //   83ec08               | sub                 esp, 8
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     

        $sequence_6 = { ff15???????? e9???????? c745fcffffffff 8d4d84 e8???????? }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   e9????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4d84               | lea                 ecx, [ebp - 0x7c]
            //   e8????????           |                     

        $sequence_7 = { 6a44 6a00 8d45b0 50 e8???????? }
            // n = 5, score = 100
            //   6a44                 | push                0x44
            //   6a00                 | push                0
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 894dfc 8b45fc 50 ff15???????? 8b45fc 8be5 5d }
            // n = 7, score = 100
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_9 = { 6a00 6a00 ff15???????? 6a17 6a00 68???????? }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6a17                 | push                0x17
            //   6a00                 | push                0
            //   68????????           |                     

    condition:
        7 of them and filesize < 49152
}