rule win_woodyrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.woodyrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.woodyrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? c745fcffffffff 83c404 8b4db0 8bf8 85c9 7411 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   83c404               | add                 esp, 4
            //   8b4db0               | mov                 ecx, dword ptr [ebp - 0x50]
            //   8bf8                 | mov                 edi, eax
            //   85c9                 | test                ecx, ecx
            //   7411                 | je                  0x13

        $sequence_1 = { c7473400000000 c7473800000000 0f104624 0f114724 f30f7e4634 660fd64734 66894624 }
            // n = 7, score = 100
            //   c7473400000000       | mov                 dword ptr [edi + 0x34], 0
            //   c7473800000000       | mov                 dword ptr [edi + 0x38], 0
            //   0f104624             | movups              xmm0, xmmword ptr [esi + 0x24]
            //   0f114724             | movups              xmmword ptr [edi + 0x24], xmm0
            //   f30f7e4634           | movq                xmm0, qword ptr [esi + 0x34]
            //   660fd64734           | movq                qword ptr [edi + 0x34], xmm0
            //   66894624             | mov                 word ptr [esi + 0x24], ax

        $sequence_2 = { 2bc1 c1f803 69f0abaaaaaa b8aaaaaa0a 8bce d1e9 2bc1 }
            // n = 7, score = 100
            //   2bc1                 | sub                 eax, ecx
            //   c1f803               | sar                 eax, 3
            //   69f0abaaaaaa         | imul                esi, eax, 0xaaaaaaab
            //   b8aaaaaa0a           | mov                 eax, 0xaaaaaaa
            //   8bce                 | mov                 ecx, esi
            //   d1e9                 | shr                 ecx, 1
            //   2bc1                 | sub                 eax, ecx

        $sequence_3 = { 0f57c0 c707???????? 0f43c8 660fd64704 8d4704 c745a800000000 50 }
            // n = 7, score = 100
            //   0f57c0               | xorps               xmm0, xmm0
            //   c707????????         |                     
            //   0f43c8               | cmovae              ecx, eax
            //   660fd64704           | movq                qword ptr [edi + 4], xmm0
            //   8d4704               | lea                 eax, [edi + 4]
            //   c745a800000000       | mov                 dword ptr [ebp - 0x58], 0
            //   50                   | push                eax

        $sequence_4 = { ff15???????? 0f57c0 c78558ecffff00000000 660fd68550ecffff 6800010000 c78554ecffff20000000 c78558ecffff00010000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   0f57c0               | xorps               xmm0, xmm0
            //   c78558ecffff00000000     | mov    dword ptr [ebp - 0x13a8], 0
            //   660fd68550ecffff     | movq                qword ptr [ebp - 0x13b0], xmm0
            //   6800010000           | push                0x100
            //   c78554ecffff20000000     | mov    dword ptr [ebp - 0x13ac], 0x20
            //   c78558ecffff00010000     | mov    dword ptr [ebp - 0x13a8], 0x100

        $sequence_5 = { 0f114630 e9???????? 8bc1 b9feffff7f 83c807 3dfeffff7f 0f47c1 }
            // n = 7, score = 100
            //   0f114630             | movups              xmmword ptr [esi + 0x30], xmm0
            //   e9????????           |                     
            //   8bc1                 | mov                 eax, ecx
            //   b9feffff7f           | mov                 ecx, 0x7ffffffe
            //   83c807               | or                  eax, 7
            //   3dfeffff7f           | cmp                 eax, 0x7ffffffe
            //   0f47c1               | cmova               eax, ecx

        $sequence_6 = { 7409 50 e8???????? 83c404 837dd000 8b45cc 7704 }
            // n = 7, score = 100
            //   7409                 | je                  0xb
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   837dd000             | cmp                 dword ptr [ebp - 0x30], 0
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   7704                 | ja                  6

        $sequence_7 = { 40 894dc8 50 ff75e0 51 e8???????? 8b45c0 }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   894dc8               | mov                 dword ptr [ebp - 0x38], ecx
            //   50                   | push                eax
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]

        $sequence_8 = { 50 8d8de4f9ffff e8???????? 8bbd10f9ffff 8d8dd8f9ffff 8b7f08 89bd10f9ffff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d8de4f9ffff         | lea                 ecx, [ebp - 0x61c]
            //   e8????????           |                     
            //   8bbd10f9ffff         | mov                 edi, dword ptr [ebp - 0x6f0]
            //   8d8dd8f9ffff         | lea                 ecx, [ebp - 0x628]
            //   8b7f08               | mov                 edi, dword ptr [edi + 8]
            //   89bd10f9ffff         | mov                 dword ptr [ebp - 0x6f0], edi

        $sequence_9 = { 899d44ffffff 50 52 c78540ffffff00000000 ff15???????? 6898000000 8d8558ffffff }
            // n = 7, score = 100
            //   899d44ffffff         | mov                 dword ptr [ebp - 0xbc], ebx
            //   50                   | push                eax
            //   52                   | push                edx
            //   c78540ffffff00000000     | mov    dword ptr [ebp - 0xc0], 0
            //   ff15????????         |                     
            //   6898000000           | push                0x98
            //   8d8558ffffff         | lea                 eax, [ebp - 0xa8]

    condition:
        7 of them and filesize < 785408
}