rule win_wscspl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wscspl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wscspl"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8464020000 8b3d???????? f644243810 8a442464 0f8481000000 3c2e }
            // n = 6, score = 400
            //   0f8464020000         | je                  0x26a
            //   8b3d????????         |                     
            //   f644243810           | test                byte ptr [esp + 0x38], 0x10
            //   8a442464             | mov                 al, byte ptr [esp + 0x64]
            //   0f8481000000         | je                  0x87
            //   3c2e                 | cmp                 al, 0x2e

        $sequence_1 = { 885c342c ffd5 a3???????? a3???????? b8???????? }
            // n = 5, score = 400
            //   885c342c             | mov                 byte ptr [esp + esi + 0x2c], bl
            //   ffd5                 | call                ebp
            //   a3????????           |                     
            //   a3????????           |                     
            //   b8????????           |                     

        $sequence_2 = { 33d2 33c9 8d5c2418 e8???????? 8b8c2494230000 83c414 5b }
            // n = 7, score = 400
            //   33d2                 | xor                 edx, edx
            //   33c9                 | xor                 ecx, ecx
            //   8d5c2418             | lea                 ebx, [esp + 0x18]
            //   e8????????           |                     
            //   8b8c2494230000       | mov                 ecx, dword ptr [esp + 0x2394]
            //   83c414               | add                 esp, 0x14
            //   5b                   | pop                 ebx

        $sequence_3 = { c705????????01000000 e8???????? 891d???????? eb25 }
            // n = 4, score = 400
            //   c705????????01000000     |     
            //   e8????????           |                     
            //   891d????????         |                     
            //   eb25                 | jmp                 0x27

        $sequence_4 = { 51 50 ff15???????? 2935???????? 83c40c }
            // n = 5, score = 400
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   2935????????         |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { 5f 8935???????? 5e 5d 8b8c2488230000 }
            // n = 5, score = 400
            //   5f                   | pop                 edi
            //   8935????????         |                     
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   8b8c2488230000       | mov                 ecx, dword ptr [esp + 0x2388]

        $sequence_6 = { 6a01 50 ff15???????? 687c230000 68c10b0000 }
            // n = 5, score = 400
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   687c230000           | push                0x237c
            //   68c10b0000           | push                0xbc1

        $sequence_7 = { 8d443410 68???????? 50 e8???????? 668b0d???????? }
            // n = 5, score = 400
            //   8d443410             | lea                 eax, [esp + esi + 0x10]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   668b0d????????       |                     

        $sequence_8 = { 68ba0b0000 33d2 33c9 8d9c24a4050000 }
            // n = 4, score = 400
            //   68ba0b0000           | push                0xbba
            //   33d2                 | xor                 edx, edx
            //   33c9                 | xor                 ecx, ecx
            //   8d9c24a4050000       | lea                 ebx, [esp + 0x5a4]

        $sequence_9 = { 2bc1 8b4c2448 03f0 8b442444 ba3f3a0000 }
            // n = 5, score = 400
            //   2bc1                 | sub                 eax, ecx
            //   8b4c2448             | mov                 ecx, dword ptr [esp + 0x48]
            //   03f0                 | add                 esi, eax
            //   8b442444             | mov                 eax, dword ptr [esp + 0x44]
            //   ba3f3a0000           | mov                 edx, 0x3a3f

    condition:
        7 of them and filesize < 901120
}