rule win_xagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xagent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1ea02 6bd20d b801000000 2bc2 }
            // n = 4, score = 2900
            //   c1ea02               | shr                 edx, 2
            //   6bd20d               | imul                edx, edx, 0xd
            //   b801000000           | mov                 eax, 1
            //   2bc2                 | sub                 eax, edx

        $sequence_1 = { ff15???????? 8bd8 e8???????? 03d8 }
            // n = 4, score = 2900
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     
            //   03d8                 | add                 ebx, eax

        $sequence_2 = { 7702 2bc7 8b5204 8b0482 8b0488 8b4e10 85c9 }
            // n = 7, score = 2600
            //   7702                 | ja                  4
            //   2bc7                 | sub                 eax, edi
            //   8b5204               | mov                 edx, dword ptr [edx + 4]
            //   8b0482               | mov                 eax, dword ptr [edx + eax*4]
            //   8b0488               | mov                 eax, dword ptr [eax + ecx*4]
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   85c9                 | test                ecx, ecx

        $sequence_3 = { 33d2 eb02 8b11 8b4808 8bc1 57 8b7a08 }
            // n = 7, score = 2600
            //   33d2                 | xor                 edx, edx
            //   eb02                 | jmp                 4
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   8bc1                 | mov                 eax, ecx
            //   57                   | push                edi
            //   8b7a08               | mov                 edi, dword ptr [edx + 8]

        $sequence_4 = { 8b7a08 c1e802 83e103 3bf8 7702 2bc7 8b5204 }
            // n = 7, score = 2600
            //   8b7a08               | mov                 edi, dword ptr [edx + 8]
            //   c1e802               | shr                 eax, 2
            //   83e103               | and                 ecx, 3
            //   3bf8                 | cmp                 edi, eax
            //   7702                 | ja                  4
            //   2bc7                 | sub                 eax, edi
            //   8b5204               | mov                 edx, dword ptr [edx + 4]

        $sequence_5 = { 55 8bec 33c0 83ec0c 39412c }
            // n = 5, score = 2600
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   33c0                 | xor                 eax, eax
            //   83ec0c               | sub                 esp, 0xc
            //   39412c               | cmp                 dword ptr [ecx + 0x2c], eax

        $sequence_6 = { 7507 c7460c00000000 5f 5e 8be5 }
            // n = 5, score = 2600
            //   7507                 | jne                 9
            //   c7460c00000000       | mov                 dword ptr [esi + 0xc], 0
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

        $sequence_7 = { e8???????? 8b4604 85c0 7407 8b4d08 8b11 8910 }
            // n = 7, score = 2600
            //   e8????????           |                     
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8910                 | mov                 dword ptr [eax], edx

        $sequence_8 = { ff15???????? 6a08 e8???????? 83c404 85c0 }
            // n = 5, score = 2600
            //   ff15????????         |                     
            //   6a08                 | push                8
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_9 = { 03ff 3b7e0c 7707 c7460c00000000 49 894e10 7507 }
            // n = 7, score = 2600
            //   03ff                 | add                 edi, edi
            //   3b7e0c               | cmp                 edi, dword ptr [esi + 0xc]
            //   7707                 | ja                  9
            //   c7460c00000000       | mov                 dword ptr [esi + 0xc], 0
            //   49                   | dec                 ecx
            //   894e10               | mov                 dword ptr [esi + 0x10], ecx
            //   7507                 | jne                 9

        $sequence_10 = { 7509 488b03 488bcb ff5008 488b7d8f 4883c610 488d46f8 }
            // n = 7, score = 1300
            //   7509                 | jne                 0xb
            //   488b03               | dec                 eax
            //   488bcb               | mov                 eax, dword ptr [ebx]
            //   ff5008               | dec                 eax
            //   488b7d8f             | mov                 ecx, ebx
            //   4883c610             | call                dword ptr [eax + 8]
            //   488d46f8             | dec                 eax

        $sequence_11 = { e8???????? 48833b00 740a 488b4308 }
            // n = 4, score = 1300
            //   e8????????           |                     
            //   48833b00             | mov                 edx, dword ptr [ebx]
            //   740a                 | dec                 eax
            //   488b4308             | mov                 dword ptr [ebx], eax

        $sequence_12 = { 4883ec30 4883792800 498bf9 498bf0 }
            // n = 4, score = 1300
            //   4883ec30             | mov                 edi, eax
            //   4883792800           | dec                 eax
            //   498bf9               | sub                 edi, edx
            //   498bf0               | dec                 eax

        $sequence_13 = { 740c 488b07 4c8b13 488903 4c8917 488b13 488b0e }
            // n = 7, score = 1300
            //   740c                 | dec                 eax
            //   488b07               | mov                 edi, dword ptr [ebp - 0x71]
            //   4c8b13               | dec                 eax
            //   488903               | add                 esi, 0x10
            //   4c8917               | jne                 0xb
            //   488b13               | dec                 eax
            //   488b0e               | mov                 eax, dword ptr [ebx]

        $sequence_14 = { e8???????? 488b4328 4c8bcf 4c8bc6 }
            // n = 4, score = 1300
            //   e8????????           |                     
            //   488b4328             | dec                 eax
            //   4c8bcf               | mov                 eax, dword ptr [edi]
            //   4c8bc6               | dec                 esp

        $sequence_15 = { 0f92c3 488d4c2430 e8???????? 90 }
            // n = 4, score = 1300
            //   0f92c3               | lea                 eax, [edi + 1]
            //   488d4c2430           | jne                 0xfffffffa
            //   e8????????           |                     
            //   90                   | dec                 eax

        $sequence_16 = { e8???????? 90 0fb705???????? 6689442420 }
            // n = 4, score = 1300
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [edi], edx
            //   0fb705????????       |                     
            //   6689442420           | je                  0xe

        $sequence_17 = { 740c 488b07 488b0b 488903 48890f 488b5c2430 488b6c2438 }
            // n = 7, score = 1300
            //   740c                 | mov                 edx, dword ptr [ebx]
            //   488b07               | dec                 eax
            //   488b0b               | mov                 ecx, dword ptr [esi]
            //   488903               | je                  0xe
            //   48890f               | dec                 eax
            //   488b5c2430           | mov                 eax, dword ptr [edi]
            //   488b6c2438           | dec                 esp

        $sequence_18 = { b803b57ea5 f7e6 c1ea06 6bd263 }
            // n = 4, score = 500
            //   b803b57ea5           | je                  0x10
            //   f7e6                 | jne                 6
            //   c1ea06               | mov                 al, 1
            //   6bd263               | jmp                 6

        $sequence_19 = { 75f8 488d8c2430010000 482bc1 488d8c0430010000 }
            // n = 4, score = 200
            //   75f8                 | mov                 ecx, eax
            //   488d8c2430010000     | jne                 0xfffffffa
            //   482bc1               | dec                 eax
            //   488d8c0430010000     | mov                 edi, ecx

        $sequence_20 = { 75f8 488bf9 482bfe 2bfb }
            // n = 4, score = 200
            //   75f8                 | dec                 eax
            //   488bf9               | mov                 edi, eax
            //   482bfe               | dec                 eax
            //   2bfb                 | sub                 edi, edx

        $sequence_21 = { 75f8 488bf9 482bfb 448bcf }
            // n = 4, score = 200
            //   75f8                 | cmp                 al, 1
            //   488bf9               | jne                 6
            //   482bfb               | mov                 al, 1
            //   448bcf               | jmp                 6

        $sequence_22 = { 75f8 488d4c2420 482bc1 488d4c0420 }
            // n = 4, score = 200
            //   75f8                 | mov                 edi, eax
            //   488d4c2420           | dec                 eax
            //   482bc1               | sub                 edi, edx
            //   488d4c0420           | dec                 eax

        $sequence_23 = { 75f8 488bf9 482bfa 4c8bc7 }
            // n = 4, score = 200
            //   75f8                 | jmp                 6
            //   488bf9               | xor                 al, al
            //   482bfa               | cmp                 al, 1
            //   4c8bc7               | jne                 6

        $sequence_24 = { 75f8 488bf8 482bfa 488b4b28 }
            // n = 4, score = 200
            //   75f8                 | xor                 al, al
            //   488bf8               | cmp                 al, 1
            //   482bfa               | jne                 6
            //   488b4b28             | mov                 al, 1

        $sequence_25 = { 75f8 492bc3 488bcf 6645892c03 }
            // n = 4, score = 200
            //   75f8                 | mov                 edi, ecx
            //   492bc3               | dec                 eax
            //   488bcf               | sub                 edi, ebx
            //   6645892c03           | inc                 esp

    condition:
        7 of them and filesize < 729088
}