rule win_xbot_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xbot_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xbot_pos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c685d3fcffff00 c745fcffffffff 8d4dd0 e8???????? }
            // n = 4, score = 100
            //   c685d3fcffff00       | mov                 byte ptr [ebp - 0x32d], 0
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e8????????           |                     

        $sequence_1 = { 6bc230 03048de0465600 b901000000 c1e100 c644082a0a 807dff01 }
            // n = 6, score = 100
            //   6bc230               | imul                eax, edx, 0x30
            //   03048de0465600       | add                 eax, dword ptr [ecx*4 + 0x5646e0]
            //   b901000000           | mov                 ecx, 1
            //   c1e100               | shl                 ecx, 0
            //   c644082a0a           | mov                 byte ptr [eax + ecx + 0x2a], 0xa
            //   807dff01             | cmp                 byte ptr [ebp - 1], 1

        $sequence_2 = { eb0a c78558fcffff01000000 8a9558fcffff 88959ffdffff }
            // n = 4, score = 100
            //   eb0a                 | jmp                 0xc
            //   c78558fcffff01000000     | mov    dword ptr [ebp - 0x3a8], 1
            //   8a9558fcffff         | mov                 dl, byte ptr [ebp - 0x3a8]
            //   88959ffdffff         | mov                 byte ptr [ebp - 0x261], dl

        $sequence_3 = { 005f56 4d 005f56 4d 0026 56 4d }
            // n = 7, score = 100
            //   005f56               | add                 byte ptr [edi + 0x56], bl
            //   4d                   | dec                 ebp
            //   005f56               | add                 byte ptr [edi + 0x56], bl
            //   4d                   | dec                 ebp
            //   0026                 | add                 byte ptr [esi], ah
            //   56                   | push                esi
            //   4d                   | dec                 ebp

        $sequence_4 = { e8???????? c685bbfdffff01 c745fcffffffff 8d8da8feffff e8???????? 8a85bbfdffff 52 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c685bbfdffff01       | mov                 byte ptr [ebp - 0x245], 1
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d8da8feffff         | lea                 ecx, [ebp - 0x158]
            //   e8????????           |                     
            //   8a85bbfdffff         | mov                 al, byte ptr [ebp - 0x245]
            //   52                   | push                edx

        $sequence_5 = { 4c 005166 4c 004566 4c 007566 4c }
            // n = 7, score = 100
            //   4c                   | dec                 esp
            //   005166               | add                 byte ptr [ecx + 0x66], dl
            //   4c                   | dec                 esp
            //   004566               | add                 byte ptr [ebp + 0x66], al
            //   4c                   | dec                 esp
            //   007566               | add                 byte ptr [ebp + 0x66], dh
            //   4c                   | dec                 esp

        $sequence_6 = { 743e 83ec0c 8bc4 89a5ecfeffff 6a00 50 8d4d0c }
            // n = 7, score = 100
            //   743e                 | je                  0x40
            //   83ec0c               | sub                 esp, 0xc
            //   8bc4                 | mov                 eax, esp
            //   89a5ecfeffff         | mov                 dword ptr [ebp - 0x114], esp
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]

        $sequence_7 = { 83e13f 6bd130 8b0485e0465600 0fb64c1028 83e140 740f }
            // n = 6, score = 100
            //   83e13f               | and                 ecx, 0x3f
            //   6bd130               | imul                edx, ecx, 0x30
            //   8b0485e0465600       | mov                 eax, dword ptr [eax*4 + 0x5646e0]
            //   0fb64c1028           | movzx               ecx, byte ptr [eax + edx + 0x28]
            //   83e140               | and                 ecx, 0x40
            //   740f                 | je                  0x11

        $sequence_8 = { c68583f9ffff01 eb07 c68583f9ffff00 8a8d83f9ffff 888dcbfbffff 8b45e8 8a8dd7fbffff }
            // n = 7, score = 100
            //   c68583f9ffff01       | mov                 byte ptr [ebp - 0x67d], 1
            //   eb07                 | jmp                 9
            //   c68583f9ffff00       | mov                 byte ptr [ebp - 0x67d], 0
            //   8a8d83f9ffff         | mov                 cl, byte ptr [ebp - 0x67d]
            //   888dcbfbffff         | mov                 byte ptr [ebp - 0x435], cl
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8a8dd7fbffff         | mov                 cl, byte ptr [ebp - 0x429]

        $sequence_9 = { e8???????? 83c404 83e03f 6bc830 030cb5e0465600 894de4 eb07 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   83e03f               | and                 eax, 0x3f
            //   6bc830               | imul                ecx, eax, 0x30
            //   030cb5e0465600       | add                 ecx, dword ptr [esi*4 + 0x5646e0]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   eb07                 | jmp                 9

    condition:
        7 of them and filesize < 3031040
}