rule win_xenarmor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xenarmor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xenarmor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7f9 8b8d64ffffff 6640 66034616 8bd0 e8???????? f7462440010000 }
            // n = 7, score = 100
            //   f7f9                 | idiv                ecx
            //   8b8d64ffffff         | mov                 ecx, dword ptr [ebp - 0x9c]
            //   6640                 | inc                 ax
            //   66034616             | add                 ax, word ptr [esi + 0x16]
            //   8bd0                 | mov                 edx, eax
            //   e8????????           |                     
            //   f7462440010000       | test                dword ptr [esi + 0x24], 0x140

        $sequence_1 = { e8???????? 8bf0 83c418 85f6 0f84ed000000 8d8584e5ffff 8d8dfcd1ffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c418               | add                 esp, 0x18
            //   85f6                 | test                esi, esi
            //   0f84ed000000         | je                  0xf3
            //   8d8584e5ffff         | lea                 eax, [ebp - 0x1a7c]
            //   8d8dfcd1ffff         | lea                 ecx, [ebp - 0x2e04]

        $sequence_2 = { e8???????? 50 8d4d08 c645fc03 e8???????? c645fc00 8bc7 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   e8????????           |                     
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   8bc7                 | mov                 eax, edi

        $sequence_3 = { e9???????? ff7304 8b53bc ff73e0 8b4d0c e8???????? 83c408 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   ff7304               | push                dword ptr [ebx + 4]
            //   8b53bc               | mov                 edx, dword ptr [ebx - 0x44]
            //   ff73e0               | push                dword ptr [ebx - 0x20]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_4 = { ff742428 ba56000000 ff742428 e8???????? 83c40c eb33 8b542420 }
            // n = 7, score = 100
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   ba56000000           | mov                 edx, 0x56
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb33                 | jmp                 0x35
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]

        $sequence_5 = { 8bf0 e8???????? 8b5df0 8bf8 57 56 ba35000000 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   8b5df0               | mov                 ebx, dword ptr [ebp - 0x10]
            //   8bf8                 | mov                 edi, eax
            //   57                   | push                edi
            //   56                   | push                esi
            //   ba35000000           | mov                 edx, 0x35

        $sequence_6 = { 8d8ff8000000 e8???????? 895de8 c745e4d4ee6800 ff750c 8d4de4 895dfc }
            // n = 7, score = 100
            //   8d8ff8000000         | lea                 ecx, [edi + 0xf8]
            //   e8????????           |                     
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   c745e4d4ee6800       | mov                 dword ptr [ebp - 0x1c], 0x68eed4
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx

        $sequence_7 = { f6400408 0f8589000000 83783000 8b44246c 741c 85c0 7518 }
            // n = 7, score = 100
            //   f6400408             | test                byte ptr [eax + 4], 8
            //   0f8589000000         | jne                 0x8f
            //   83783000             | cmp                 dword ptr [eax + 0x30], 0
            //   8b44246c             | mov                 eax, dword ptr [esp + 0x6c]
            //   741c                 | je                  0x1e
            //   85c0                 | test                eax, eax
            //   7518                 | jne                 0x1a

        $sequence_8 = { ba74000000 e8???????? 83c40c eb37 8d4201 89416c 8d0c92 }
            // n = 7, score = 100
            //   ba74000000           | mov                 edx, 0x74
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb37                 | jmp                 0x39
            //   8d4201               | lea                 eax, [edx + 1]
            //   89416c               | mov                 dword ptr [ecx + 0x6c], eax
            //   8d0c92               | lea                 ecx, [edx + edx*4]

        $sequence_9 = { 8bce e8???????? 685e010000 8bce e8???????? 8b86a8b30500 038690b30500 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   685e010000           | push                0x15e
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b86a8b30500         | mov                 eax, dword ptr [esi + 0x5b3a8]
            //   038690b30500         | add                 eax, dword ptr [esi + 0x5b390]

    condition:
        7 of them and filesize < 10894336
}