rule win_xfilesstealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xfilesstealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xfilesstealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd3 488b06 488b5818 488bcb ff15???????? 488bce 498bd4 }
            // n = 7, score = 100
            //   ffd3                 | mov                 eax, dword ptr [esi + 0x2c]
            //   488b06               | dec                 eax
            //   488b5818             | mov                 dword ptr [esp + 0x28], eax
            //   488bcb               | dec                 eax
            //   ff15????????         |                     
            //   488bce               | mov                 dword ptr [esp + 0x20], esi
            //   498bd4               | mov                 ecx, edi

        $sequence_1 = { f70100000008 757e 83fe05 41b901000000 4c8bdb 448bd6 440f47ca }
            // n = 7, score = 100
            //   f70100000008         | dec                 ecx
            //   757e                 | mov                 esp, ebx
            //   83fe05               | mov                 eax, dword ptr [esp + 0x50]
            //   41b901000000         | dec                 esp
            //   4c8bdb               | lea                 ebx, [esp + 0x70]
            //   448bd6               | dec                 ecx
            //   440f47ca             | mov                 ebp, dword ptr [ebx + 0x18]

        $sequence_2 = { ff15???????? 488d4dff e8???????? 488bc8 ff15???????? 33d2 b900000100 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488d4dff             | test                eax, eax
            //   e8????????           |                     
            //   488bc8               | js                  0x3c
            //   ff15????????         |                     
            //   33d2                 | mov                 edx, dword ptr [esi + 0xc]
            //   b900000100           | dec                 eax

        $sequence_3 = { e8???????? 90 e9???????? 48899c24f8050000 e9???????? 488b5bff 48899c24b8040000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | mov                 ecx, ebp
            //   e9????????           |                     
            //   48899c24f8050000     | inc                 ebp
            //   e9????????           |                     
            //   488b5bff             | mov                 eax, edi
            //   48899c24b8040000     | dec                 ecx

        $sequence_4 = { e8???????? 4533c0 4533c9 488bcd 418d506d e8???????? 488b4e08 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4533c0               | dec                 eax
            //   4533c9               | mov                 eax, dword ptr [edi]
            //   488bcd               | dec                 eax
            //   418d506d             | mov                 ebx, dword ptr [eax + 0x40]
            //   e8????????           |                     
            //   488b4e08             | dec                 eax

        $sequence_5 = { f6c25f 740a 488b4c2428 e8???????? b801000000 488b9c2480000000 4883c470 }
            // n = 7, score = 100
            //   f6c25f               | inc                 esp
            //   740a                 | mov                 eax, eax
            //   488b4c2428           | mov                 eax, dword ptr [esp + 0x38]
            //   e8????????           |                     
            //   b801000000           | cmp                 eax, 2
            //   488b9c2480000000     | jne                 0xbef
            //   4883c470             | inc                 eax

        $sequence_6 = { ff15???????? ba00000027 488bcf ffd3 448bf0 4585f6 0f84ee000000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   ba00000027           | mov                 ebx, dword ptr [esp + 0x60]
            //   488bcf               | dec                 eax
            //   ffd3                 | add                 esp, 0x50
            //   448bf0               | pop                 edi
            //   4585f6               | ret                 
            //   0f84ee000000         | dec                 eax

        $sequence_7 = { ff15???????? 488bcf ffd3 44896d8f bb01000000 488d542430 488b4e10 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488bcf               | lea                 edx, [esp + 0x40]
            //   ffd3                 | mov                 ecx, dword ptr [esp + 0x68]
            //   44896d8f             | test                ecx, ecx
            //   bb01000000           | jns                 0x16b9
            //   488d542430           | dec                 esp
            //   488b4e10             | cmp                 dword ptr [esp + 0x50], esp

        $sequence_8 = { ffd3 6644396de0 741b 498b96f8020000 b9a5111380 e8???????? 8bf0 }
            // n = 7, score = 100
            //   ffd3                 | jae                 0x384
            //   6644396de0           | dec                 ecx
            //   741b                 | mov                 eax, ecx
            //   498b96f8020000       | inc                 ecx
            //   b9a5111380           | and                 ecx, 0x1f
            //   e8????????           |                     
            //   8bf0                 | mov                 edx, ecx

        $sequence_9 = { ff15???????? 85c0 7507 e8???????? 8bf8 488d4d00 e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   7507                 | lea                 ecx, [edi + 0x890]
            //   e8????????           |                     
            //   8bf8                 | dec                 eax
            //   488d4d00             | lea                 ecx, [edi + 0x890]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 20821780
}