rule win_xfsadm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xfsadm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xfsadm"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740f 83f8fe 740a 6bce38 030c95f8d84200 f6412d01 7414 }
            // n = 7, score = 100
            //   740f                 | je                  0x11
            //   83f8fe               | cmp                 eax, -2
            //   740a                 | je                  0xc
            //   6bce38               | imul                ecx, esi, 0x38
            //   030c95f8d84200       | add                 ecx, dword ptr [edx*4 + 0x42d8f8]
            //   f6412d01             | test                byte ptr [ecx + 0x2d], 1
            //   7414                 | je                  0x16

        $sequence_1 = { 8d7301 80fa78 7577 385903 }
            // n = 4, score = 100
            //   8d7301               | lea                 esi, [ebx + 1]
            //   80fa78               | cmp                 dl, 0x78
            //   7577                 | jne                 0x79
            //   385903               | cmp                 byte ptr [ecx + 3], bl

        $sequence_2 = { 895e04 eb03 8b5e04 893c83 ff4634 }
            // n = 5, score = 100
            //   895e04               | mov                 dword ptr [esi + 4], ebx
            //   eb03                 | jmp                 5
            //   8b5e04               | mov                 ebx, dword ptr [esi + 4]
            //   893c83               | mov                 dword ptr [ebx + eax*4], edi
            //   ff4634               | inc                 dword ptr [esi + 0x34]

        $sequence_3 = { 83c404 8b5d0c c7461000000000 c7461400000000 c7461800000000 8d4b01 8a03 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   c7461400000000       | mov                 dword ptr [esi + 0x14], 0
            //   c7461800000000       | mov                 dword ptr [esi + 0x18], 0
            //   8d4b01               | lea                 ecx, [ebx + 1]
            //   8a03                 | mov                 al, byte ptr [ebx]

        $sequence_4 = { 6a03 6808020000 ff15???????? 68???????? ff75e0 ff75dc }
            // n = 6, score = 100
            //   6a03                 | push                3
            //   6808020000           | push                0x208
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   ff75dc               | push                dword ptr [ebp - 0x24]

        $sequence_5 = { 8b12 8b42f8 2b4afc 2bc7 0bc8 }
            // n = 5, score = 100
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   8b42f8               | mov                 eax, dword ptr [edx - 8]
            //   2b4afc               | sub                 ecx, dword ptr [edx - 4]
            //   2bc7                 | sub                 eax, edi
            //   0bc8                 | or                  ecx, eax

        $sequence_6 = { 894df0 83c104 50 e8???????? 8bf8 85ff 0f84cb000000 }
            // n = 7, score = 100
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   83c104               | add                 ecx, 4
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   0f84cb000000         | je                  0xd1

        $sequence_7 = { a3???????? 85c0 0f8475010000 68???????? ff35???????? ffd6 a3???????? }
            // n = 7, score = 100
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8475010000         | je                  0x17b
            //   68????????           |                     
            //   ff35????????         |                     
            //   ffd6                 | call                esi
            //   a3????????           |                     

        $sequence_8 = { 8b7b20 8b7324 6a00 ff10 8b06 8bce 53 }
            // n = 7, score = 100
            //   8b7b20               | mov                 edi, dword ptr [ebx + 0x20]
            //   8b7324               | mov                 esi, dword ptr [ebx + 0x24]
            //   6a00                 | push                0
            //   ff10                 | call                dword ptr [eax]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bce                 | mov                 ecx, esi
            //   53                   | push                ebx

        $sequence_9 = { f20f593c85604f4200 660f122c85604f4200 03c0 660f28348570534200 }
            // n = 4, score = 100
            //   f20f593c85604f4200     | mulsd    xmm7, qword ptr [eax*4 + 0x424f60]
            //   660f122c85604f4200     | movlpd    xmm5, qword ptr [eax*4 + 0x424f60]
            //   03c0                 | add                 eax, eax
            //   660f28348570534200     | movapd    xmm6, xmmword ptr [eax*4 + 0x425370]

    condition:
        7 of them and filesize < 566272
}